
# Copyright (c) 2003 Frederick Dean

use strict;

package bid;

# Gtk stuff
my %bid_button;  # Gtk::Button  key is 1S, 2NT, 3C, etc.
my %bid_label;   # Gtk::Label  key is E1, N2, W2, etc.
my $hbox2;  # hint, auto, pass, double
my $history_row;  # Which row of the history table are we recording to.
my $double_button;  #  Gtk::Button
# Game state
my $bidder;  # "N", "S", etc.
my $passes_to_go;  # Number of passes which would end bidding
my($turn,$turn_of_open);  # turn start with 1 and counts up
our @bids = (undef);  # turn 1 is $bids[1] ($bids[0] is garbage)
our $decl;  # keep here until we publish in $::declarer (so cards don't show early)
# Some constant stuff
my @bid_order = qw/1C 1D 1H 1S 1NT 2C 2D 2H 2S 2NT 3C 3D 3H 3S 3NT 
   4C 4D 4H 4S 4NT 5C 5D 5H 5S 5NT 6C 6D 6H 6S 6NT 7C 7D 7H 7S 7NT/;
my $rank = 2;
my %bid_rank = map { ($_,$rank++) } @bid_order;
$bid_rank{'pass'} = 1;
my %honor_points = ( "A" => 4, "K" => 3, "Q" => 2, "J" => 1 );

# These are ugly globals used during a bid_ai() call.  None are kept after the call.
my($points,$honor_pts,$clubs,$diamonds,$hearts,$spades);
my %counts; # = ( "S" => $spades, "H" => $hearts, "D" => $diamonds, "C" => $clubs );
my @ordered; # = sort ($clubs, $hearts, $diamonds, $spades);    "list of lengths"
my $open_suit;

# Does bidder have this card.
sub has { substr($::where{$_[0]},0,1) eq $bidder }

sub suit_honor_points
{
   my($dir,$suit) = @_;
   $suit = substr($suit,0,1);  # keep only first letter of suit
   my $points = 0;
   foreach my $card (::sorted_hand($dir)) {  # for every card in the hand
      next unless substr($card,0,1) eq $suit;  # skip if wrong suit
      $points += $honor_points{substr($card,1,1)} || 0;
   }
   return $points;
}

sub hand_points
{
   my($dir) = @_;
   my %suitcount;
   my $points = 0;
   foreach my $card (::sorted_hand($dir)) {  # for every card in the hand
      $suitcount{ substr($card,0,1) } ++;
      $points += $honor_points{substr($card,1,1)} || 0;
   }
   my $honor_pts = $points;
   foreach my $count (values %suitcount) {
      $points += $count - 4 if $count > 4;
   }
   return($points,$honor_pts,$suitcount{'C'}||0,$suitcount{'D'}||0,$suitcount{'H'}||0,$suitcount{'S'}||0);
}

# Count quick tricks.  Each ace is a quick trick.  Each king with ace of same suit is another. etc.
sub quick_tricks
{
   my $qt = 0;
   foreach my $suit (qw/C D H S/) {
      foreach my $rank (qw/A K Q J T 9 8 7 6 5 4 3 2/) {
         last unless has($suit . $rank);
         $qt++;
      }
   }
   return $qt;
}

# Bit as low as possible, but in this suit
sub min_suit_bid
{
   my($suit) = @_;
   my $contract_length = substr($::contract,0,1);  
   return "$contract_length$suit" if can_bid("$contract_length$suit");
   return ($contract_length+1) . $suit;
}

sub opening_bid_sub_one_ai
{
   my($clubs,$diamonds,$hearts,$spades) = @_;
   if($clubs >= 7 || $diamonds >= 7 || $hearts >= 7 || $spades >= 7) { # if seven card suit
      if($passes_to_go == 1) {  # if fourth hand
         # FIXME can win 9+ tricks?  bid them   (i.e. looong suits)
      };
      # FIXME shutout bid
   };
   # FIXME weak 2-card bids
   return "pass";
}

sub bid_ai_opening
{
   my $qt = quick_tricks();
   print("bid_ai_opening() bidder=$bidder points=$points honor_pts=$honor_pts c=$clubs d=$diamonds h=$hearts s=$spades qt=$qt\n") if $::debug;
   # open 1NT if we can   
   return "1NT" if($honor_pts >= 16 && $honor_pts <= 18 &&   # 16 to 18 high card points
      $clubs > 1 && $clubs < 6 && $diamonds > 1 && $diamonds < 6 &&  # no singletons, no 6+ card suits
      $hearts > 1 && $hearts < 5 && $spades > 1 && $spades < 5);  # no 5+ card majors
   # flannery 2D
#   return "2D" if($honor_pts >= 11 && $honor_pts <= 15 &&   # 11 to 15 high card points
#      $spades == 4 && $hearts == 5 );  # four spades and five hearts
   # sub-one level bid
   if(!($points >= 14 ||  # if 14 points
        ($qt >= 2  && ($points >= 13 || $honor_pts >= 12)) || # or two quick tricks and (13 points or 12 honor points)
        ($qt >= 2  && $points >= 10 && $spades >= 5 && $hearts >= 5) || # or two quick tricks and 10 HCP and 5+ in both honors
        ($passes_to_go<3 && $honor_pts>=10 && ($qt>=2 || $hearts>=5 || $spades>=5))|| #or after 2 passes, 10 HCP and either 2 QT or five card major
        ($passes_to_go==1 && $honor_pts+$spades>=15 && $spades>=5))){ #or after 3 passes, HCP + spades >= 15, and spades >= 5
      return opening_bid_sub_one_ai($clubs,$diamonds,$hearts,$spades);
   }
   # FIXME benjamin weak twos
   # see about 2 bids
   if($points >= 23 || ($points >= 21 && ($clubs >= 6 || $diamonds >= 6 || $hearts >= 5 || $spades >= 5))) {
      my @ordered = sort ($clubs, $hearts, $diamonds, $spades); # sort list of lengths
      my $longest = $ordered[3];  # determine length of longest suit
      if($longest >= 5) {  # if five card suit (or longer)
         return "2S" if $longest == $spades;
         return "2H" if $longest == $hearts;
         return "2D" if $longest == $diamonds;
         return "2C" if $longest == $clubs;
      }
      if($ordered[0] == 1 && $ordered[1] == 4 && $ordered[2] == 4) { # if 4-4-4-1
         if(($clubs    == 1 && (has("CA") || has("CK"))) ||  # if singleton is ace or king
            ($diamonds == 1 && (has("DA") || has("DK"))) ||
            ($hearts   == 1 && (has("HA") || has("HK"))) ||
            ($spades   == 1 && (has("SA") || has("SK")))) {
            return "3NT" if $points > 24;
            return "2NT";
         } # else bid better suit
         return "2C" if $diamonds == 1;
         return "2D" if $clubs == 1;
         return "2D" if suit_honor_points($bidder,"Diamonds") >= suit_honor_points($bidder,"Clubs");  # bid better minor suit
         return "2C";  # bid better minor suit
      }
   }; 
   if($honor_pts >= 22 && $clubs >= 1 && $hearts >= 1 && $diamonds >= 1 && $spades >= 1 &&  # 22+ HCP, no singletons
                          $clubs <= 6 && $hearts <= 6 && $diamonds <= 6 && $spades <= 6) {  # no 6+ card suits
      return "3NT" if $honor_pts >= 25; 
      return "2NT";  
   }
   if($spades >= 5 && $hearts >= 5) { # if two five card majors
      return "1S" if $spades >= $hearts;
      return "1H";
   };
   return "1S" if($spades >= 5); # if five card major
   return "1H" if($hearts >= 5); # if five card major 
   # else one level hand with no five card major
   return "1D" if $diamonds > $clubs;
   return "1D" if $diamonds >= 4 && $clubs < 6;
   return "1C" if $clubs > $diamonds;
   return "1C";  # three diamonds and three clubs
}

# Is the bid better than the current contract?
sub can_bid  { return $bid_rank{$_[0]} > $bid_rank{$::contract} } 

# left of opener in some 1NT or 2x opens
sub bid_ai_leap_of_faith
{
   # Here you must expect your partner has little, and bet your own hand
   # FIXME vulnerable?  strong-6
   if($spades >= 7 && $points >= 15) {  # I am making up 15 here
      return "2S" if can_bid("2S");
      return "3S" if can_bid("2S");
   };
   if($hearts >= 7 && $points >= 15) {
      return "2H" if can_bid("2H");
      return "3H" if can_bid("2H");
   };
   if($diamonds >= 7 && $points >= 15) {
      return "2D" if can_bid("2D");
      return "3D" if can_bid("2D");
   };
   if($clubs >= 7 && $points >= 15) {
      return "2C" if can_bid("2C");
      return "3C" if can_bid("2C");
   };
   return "pass";
}

sub bid_ai_1NT
{
   return "dbl" if($honor_pts >= 16);   # FIXME "and 6 or more likely tricks"
   # FIXME 
   my $longest = $ordered[3];  # determine length of longest suit
   if($longest >= 6 && $honor_pts > 13) {  # 13?
      return "2S" if $spades   == $longest;
      return "2H" if $hearts   == $longest;
      return "2D" if $diamonds == $longest;
      return "2C" if $clubs    == $longest;
   }
   return bid_ai_leap_of_faith();
}

sub bid_ai_1
{
   # "cue bid" ?
   #if($points >= 22  # FIXME 
   # 1NT bid
   my $his_suit = substr($::contract,1,1);
   my $in_his_suit = grep { substr($_,0,1) eq $his_suit } ::sorted_hand($bidder);
   my $king_bonus  = (has($his_suit ."K") ||0) && $in_his_suit >= 2;  # bonus honor point if we have Kx in his suit
   my $queen_bonus = (has($his_suit ."Q") ||0) && $in_his_suit >= 3;  # bonus honor point if we have Qxx in his suit
   my $jack_bonus  = (has($his_suit ."J") ||0) && $in_his_suit >= 4;  # bonus honor point if we have Jxxx in his suit
   if($king_bonus+$queen_bonus+$jack_bonus &&  # if we have Kx, Qxx, or Jxxx in his suit
      $points+$queen_bonus+$king_bonus >= 16 && $points+$queen_bonus+$king_bonus <= 18 && # and 16-18 K&Q adjusted points
      $clubs > 1 && $diamonds > 1 && $hearts > 1 && $spades > 1 &&  # and no singletons
      $clubs < 6 && $diamonds < 6 && $hearts < 5 && $spades < 5) {  # and no 6+ card suits, and no 5+ card major
      # FIXME for unbiddable major stuff
      #return "1H" if $hearts >= 5 && can_bid("1H");  # if we have 5+ hearts and can bid it  # GARBAGE
      #return "1S" if $spades >= 5 && can_bid("1S");  # if we have 5+ hearts and can bid it  # GARBAGE
      return "1NT";
   }
   # take out doubles (means we have other suits covered, force partner to pick his favorite)
   #if($in_his_suit == 0) {  should be??
   if($ordered[0] == 0) {  # if 3 suit hand
      my $lost_honor_points = suit_honor_points($bidder,substr($::contract,1,1)) - $king_bonus*3 - $queen_bonus*2;
      return "dbl" if $points >= 10 &&   # if we have 10 or more high card suits
                      $in_his_suit == 0; # and our void is their bid suit
      return "dbl" if $points-$lost_honor_points >= 12 &&  # 12+ honor points (outside his suit)
                      ($::contract eq "1C" || $::contract eq "1H") && # and he bid a minor
                      $hearts >= 4 && $spades >= 4;  # and we have 4+ in each unbid major suit
      #return "dbl" if $points-$lost_honor_points >= 13 &&  # 13+ honor points (outside his suit)
      #                 $ordered[1] >= 3 && $ordered[2] >= 4 && $ordered[3] >= 4;  # no more than one 3-card unbid suit
      return "dbl" if $points-$lost_honor_points >= 16;  # 16+ honor points (outside his suit)
   }
   # 5-card unbid suit
   # FIXME me "vulnerable tricks"? for "unusual" 2NT
   if($spades >= 5 && $::contract ne "1S") {
      return "2S" if $points >= 14 && (has('SA') || has('SK') || has('SQ'));
      return "2S" if $points >= 12 && $spades >= 6;  
      return "1S" if $points >= 11;
      return "1S" if $points >= 10 && $spades >= 6;
   }
   if($hearts >= 5 && $::contract ne "1H") {
      return "2H" if $points >= 14 && (has('HA') || has('HK') || has('HQ'));
      return "2H" if $points >= 12 && $hearts >= 6;  
   }
   if($hearts >= 5 && ($::contract eq "1C" || $::contract eq "1D")) {
      return "1H" if $points >= 11;
      return "1H" if $points >= 10 && $hearts >= 6;
   }
   if($diamonds >= 5 && $::contract ne "1D") {
      return "2D" if $points >= 14 && (has('DA') || has('DK') || has('DQ'));
      return "2D" if $points >= 12 && $diamonds >= 6;  
   }
   if($diamonds >= 5 && $::contract eq "1C") {
      return "1D" if $points >= 11;
      return "1D" if $points >= 10 && $diamonds >= 6;
   }
   if($clubs >= 5 && $::contract ne "1C") {
      return "2C" if $points >= 14 && (has('CA') || has('CK') || has('CQ'));
      return "2C" if $points >= 12 && $clubs >= 6;  
   }
   # should we really check here for no 5-card suit?  Naaah
   return "dbl" if $points >= 15;
   return "pass";
}
sub bid_ai_2   # strong 2 only
{
   my $his_suit = substr($::contract,1,1);
   if($honor_pts >= 15 && $counts{$his_suit} <= 1 && $ordered[1] >= 4) { # 15 points and at least 4 cards in the other three suits
      return "dbl";
   }
   return bid_ai_leap_of_faith();
}
sub bid_ai_3
{
   return "pass" if $honor_pts < 14;
   # FIXME
}

sub bid_ai_1NT_pass
{
   if($honor_pts >= 9 || ($points >= 10 && ($spades >= 4 || $hearts >=4))) {  # if 9+ HCP, or 10 points and a 4-card major,  go for game
      return "3S" if $spades >= 5 && $hearts >= 5;
      return "2C" if $spades >= 4 || $hearts >= 4;  # if a 4+ major  Stayman!!
      return "4S" if $spades >= 6 && $points <= 13;   # bid game.   less than 13?
      return "4H" if $hearts >= 6 && $points <= 13;  
      return "3S" if $spades >= 5;   # 5+ major, bid at 3 level 
      return "3H" if $hearts >= 5;  
      return "2NT" if $points < 10;  # i.e. 8-9 points  
      return "3NT" if $points < 15;  # i.e. 10-14 points  
      return "3D" if $diamonds >= 6;
      return "3C" if $clubs >= 6;
      return "3NT" if 16 + $honor_pts <= 30; 
      return "4NT" if 16 + $honor_pts <= 32; 
      return "6NT" if 16 + $honor_pts <= 34; 
      return "5NT" if 16 + $honor_pts <= 36; 
      return "7NT" if 16 + $honor_pts >= 37; 
   }
   if($honor_pts >= 8 || #if 8+ HCP, 
     ($points >= 7 && ($spades >= 5 || $hearts >=5))) { # or 7+ pts and a 5-card suit, (or FIXME JTx or better), invite for game
      return "3S" if $spades >= 5 && $hearts >= 5;  # if two 5-card majors
      return "4S" if $spades >= 6;   # bid game.  
      return "4H" if $hearts >= 6;  
      return "2C" if $spades >= 4 || $hearts >= 4;  # Stayman!!
      # check out deal #621833028
      return "2S";    
   }  # else 8- points
   return "2C" if $hearts + $spades >= 9;  # 5-4 major    Stayman!!
   return "2C" if $hearts + $spades >= 7 && $diamonds >= 5;  # 4-3 major and 5+ diamonds Stayman!! (will pass partners response)
   return "2S" if $spades >= 5;
   return "2H" if $hearts >= 5;
   return "2D" if $diamonds >= 6;
   return "2C" if $clubs >= 6;
   return "pass";
}
sub bid_ai_1NT_dbl
{
   return "rdbl" if $honor_pts >= 8;  # redouble if HCP 8+
   return "2S" if $spades >= 6;  # bid six card suit
   return "2H" if $hearts >= 6;  
   return "2D" if $diamonds >= 6; 
   return "2C" if $clubs >= 6;
   return "pass" if $honor_pts >= 5; 
   return "2S" if $spades >= 5;  # bid five card suit
   return "2H" if $hearts >= 5;  
   return "2D" if $diamonds >= 5; 
   return "2C" if $clubs >= 5;
   return "pass";
}
sub bid_ai_1NT_x
{
   if($points >= 8) {  # if point 8+
      return "3S" if $spades >= 5 && can_bid("3S");
      return "3H" if $spades >= 5 && can_bid("3H");
      return "3D" if $spades >= 6 && can_bid("3D");
      return "3C" if $spades >= 6 && can_bid("3C");
      return "3NT" if $honor_pts >= 10;
      return "2NT" if $honor_pts >= 8;
      return "pass";
   }
   return "2S" if $spades >= 5 && $spades >= $hearts;  # Bid a 5-card suit at the two level if we can.
   return "2H" if $hearts >= 5;
   return "2D" if $diamonds >= 5;
   return "pass";
}

sub bid_ai_2NT_pass
{
   return "3S" if $spades >= 6 && $spades >= $hearts;  # bid 6-card major 
   return "3H" if $hearts >= 6;
   return "pass" if $honor_pts < 3;  # pass if less than 3 HCP
   return "3S" if $spades >= 5; # bid 5-card major 
   return "3H" if $hearts >= 5;
   return "3C" if $spades >= 4 || $hearts >= 4; # bid 4-card major (Stayman)
   return "7NT" if $honor_pts + 21 >= 37;  # my HCP + partner's minimum
   return "5NT" if $honor_pts + 21 >= 35;  # my HCP + partner's minimum  (invite partner to bid 7)
   return "6NT" if $honor_pts + 21 >= 33;  # my HCP + partner's minimum
   return "4NT" if $honor_pts + 21 >= 31;  # my HCP + partner's minimum
   return "3NT";
}
sub bid_ai_2NT_dbl
{
   return "rdbl" if $honor_pts >= 3;  # redouble if HCP 3+
   return "3S" if $spades >= 6;  # bid six card suit
   return "3H" if $hearts >= 6;  
   return "3D" if $diamonds >= 6; 
   return "3C" if $clubs >= 6;
   return "pass"
}
sub bid_ai_2NT_x
{
   my $len = $counts{substr($bids[$turn_of_open+1],1)};  # how many of his suit we have
   #return "dbl" if ($len+$honor_pts+5)/3 > ???;
   if($points < 3) {  # if we have less than three total points
      return "3S" if $spades >= 5;  # bid five card suit at 3 level if we can
      return "3H" if $hearts >= 5;
      return "3D" if $diamonds >= 5;
      return "3C" if $clubs >= 5;
   }
   return "4H" if $spades >= 5 && $hearts >= 5;  # FIXME is this cue bid right?
   return "3S" if $spades >= 5 && can_bid("3S");  # bid 5-card major or 6-card minor at 3 level if we can
   return "3H" if $hearts >= 5 && can_bid("3H"); 
   return "3D" if $diamonds >= 6 && can_bid("3D");
   return "3NT" if $honor_pts >=5 && can_bid("3NT"); # bid 3NT if can 
   return "pass";
}
sub bid_ai_xNT_y   #  where x > 2
{
   return "pass";  # FIXME
}

sub bid_ai_1s_x
{
   return "pass" if $points < 5;
   if($points == 5) {
      return "pass" if $bids[$turn_of_open+1] ne 'pass';  # pass if interference
      if($open_suit eq "S" || $open_suit eq "H") {  # if opened in major suit
         return "2$open_suit" if $counts{$open_suit} >= 4;  # if five points and 4+ cards  without interferrence
      } else { # open in minor suit
         return "1S" if $spades >= 5;
         return "1H" if $hearts >= 5;
         #return min_suit_bid("D") if $diamonds >= 6;  # "inverted minor raises" ?
         #return "2C" if $clubs >= 6;
      }
   } # else $points >= 6
   # FIXME did they take-out double
   if($bid_rank{$::contract} >= $bid_rank{"1NT"}) {  # if high overcall


   } # else no 1NT+ (high) overcall
   # FIXME "jump shift" ?
   if($open_suit eq "S" || $open_suit eq "H") { # if major open suit
      # triple raise
      return "4$open_suit" if $bids[$turn_of_open+1] eq 'pass' &&  $counts{$open_suit} >= 4 && # no interference and 4+ card support
                              $points >= 10;  # 10-12 points with less than 10 HCP
      return "4$open_suit" if $bids[$turn_of_open+1] eq 'pass' &&  $counts{$open_suit} >= 3 && # no interference and 3+ card support
                              $points >= 12;  # 12-16 total points
      # double raise
      return "3$open_suit" if $bids[$turn_of_open+1] eq 'pass' &&  $counts{$open_suit} >= 3 && # no interference and 4+ card support
         (has($open_suit . "A") || has($open_suit . "K") || has($open_suit . "Q")) &&
         $points >= 13;  # and 13-16 total points
      # single raise
      return "1S" if $bids[$turn_of_open+1] eq 'pass' && $bids[$turn_of_open] eq "1H" && $spades >= 4 && $hearts < 4 &&
                              $points >= 6;  # and 6-10 total points
      return "2$open_suit" if $bids[$turn_of_open+1] eq 'pass' &&  $counts{$open_suit} >= 3 && # no interference and 4+ card support
                              $points >= 6;  # and 6-10 total points
   };
   my $longest_suit = (sort { $counts{$b} <=> $counts{$a} || $b cmp $a } qw/C D H S/)[0];  # favor majors
   if(can_bid("1$longest_suit")) { # if we can bid our longest suit at the 1 level
      return "1H" if $longest_suit eq "S" && $hearts == $spades && $spades < 5;  # favor hearts over spades if same length
      return "1$longest_suit";
   };
   return "1S" if $spades >= 4 && can_bid("1S");  # bid four card suit at 1 level if can
   return "1H" if $hearts >= 4 && can_bid("1H"); 
   return "1D" if $diamonds >= 4 && can_bid("1D");
   return "2$longest_suit" if $points >= 10 && $counts{$longest_suit} >= 5;
   my @ordered = sort ($clubs, $hearts, $diamonds, $spades); # sort list of lengths
   # can we really get this far?
   return "3NT" if $points >= 16 && $ordered[0] == 3 && $ordered[1] == 3 && $ordered[2] == 3 && # 16-18 points and 4-3-3-2 distribution
                   ($::contract eq "1C" || $::contract eq "1D") &&  # over a minor suit opening
                   $bids[$turn_of_open+1] eq 'pass';  # with no interference
   return "3NT" if $points >= 16 && $ordered[0] == 2 && $ordered[1] == 3 && $ordered[2] == 4 && # 16-18 points and 4-3-3-2 distribution
                   ($::contract eq "1H" || $::contract eq "1S") &&  # over a major suit opening
                   $bids[$turn_of_open+1] eq 'pass' && $counts{$open_suit} == 2 ;  # with no interference.  doubleton in partners suit
   my $contract_suit = substr($::contract,1,1);
   return "3NT" if $points >= 16 && $ordered[0] > 1 && # 13-16 points and no singletons
                   (has($contract_suit ."A") ||  has($contract_suit ."K") || # stopper in opponents suit
                   (has($contract_suit ."Q") && $counts{$contract_suit} > 2)) && 
                   $bids[$turn_of_open+1] eq 'pass' && $::contract =~ /^\d\w$/;  # when right-hand partner intervened
   return "2NT" if $points >= 13 && $spades > 1 && $hearts > 1 && $diamonds > 1 && $clubs >1 && # 13-15 points, no singletons
                   $counts{$longest_suit} < 5;
   # some garbage
   return "1NT";
}
sub bid_ai_xs_x
{
   my $num_aces = grep { $_ =~ /A$/ } ::sorted_hand($bidder);
   my $num_kings = grep { $_ =~ /K$/ } ::sorted_hand($bidder);
   # return negative
   return "2NT" unless ($num_aces && ($num_kings || $honor_pts >= 8)) || # unless we have an ace and a king, or 1 quick trick and 8+ honors
                       $honor_pts > 10;  # or unless we have 10 honor points
   # return positive
   return "3$open_suit" if $counts{$open_suit} >= 3;  # raise if we have 3+ of opener's suit
   foreach my $suit (qw/S H D C/) {
      return min_suit_bid($suit) if $counts{$suit} >= 5;  # raise and change suit if we have 5+ in that suit
   }
   return "3NT";
}

sub bid_ai_1NT_pass_2C_pass  # Stayman!!
{ 
   return "2S" if $spades >= 4;  #  Golden Fit
   return "2H" if $hearts >= 4;  #  Golden Fit
   return "2D";   # nope     # FIXME
}  
sub bid_ai_1NT_pass_2NT_pass  { return "3NT" if $points >= 17; return "pass" } 
sub bid_ai_1NT_pass_4NT_pass  { return "6NT" if $points >= 17; return "pass" } 
sub bid_ai_1NT_pass_5NT_pass  { return "7NT" if $points >= 17; return "6NT" } 
sub bid_ai_1NT_pass_x_pass
{ 
   my($size,$suit) = @_;
   return $size+1 . $suit if $counts{$suit} >= 3;  # if three or more cards in their suit
   return "3NT";
}
sub bid_ai_1NT_x_2C_x_2j   # Stayman  # j = major-suit
{
   my($major_suit) = @_;
   if($counts{$major_suit} >= 4) {  # if there is a major suit match
      #return GO_FOR_SLAM if $points + 16 >= 32;    FIXME
      return "4$major_suit"; 
   }
   return "2S" if $points < 10 && $honor_pts < 7 && $spades >= 5;  # weak hand with 5-card major
   return "2H" if $points < 10 && $honor_pts < 7 && $hearts >= 5;  # weak hand with 5-card major
   return "pass" if $points < 10 && $honor_pts < 7;  # weak hand 
   return "2NT" if $points < 10;  
   return "3S" if $points < 15 && $spades >= 5;  
   return "3H" if $points < 15 && $hearts >= 5;  
   return "3NT" if $points < 15;
   return "4NT" if $points <= 16;  # 15-16 points (invite to 6NT)
   return "6NT" if $points <= 18;  # 17-18 points
   return "5NT" if $points <= 20;  # 19-20 points (invite to 7NT)
   return "7NT";  # 20+ points 
}
sub bid_ai_1NT_x_2C_x_2D
{  # FIXME
   return "3NT" if $honor_pts >= 10; 
   return "2NT";
}


# Right now we are only bidding strong 2 bids.
sub bid_ai2
{
   # opening bid
   return bid_ai_opening() if ! $turn_of_open;
   # left of opener
   my $sequence = join("-",@bids[$turn_of_open..$#bids]);    # starting with opening bid, concatenate bids with dashes
print "######## too=$turn_of_open sequence=$sequence\n";
   return bid_ai_1NT() if $sequence eq "1NT";
   return bid_ai_1() if $sequence =~ /^1\w+$/;  #    suit bid of one
   return bid_ai_2() if $sequence =~ /^2\w+$/;  #   
   return bid_ai_3() if $sequence =~ /^3\w+$/;  #  
   return "pass"     if $turn == $turn_of_open+1;  # opening bids not already matched
   # opener's partner 
   return bid_ai_1NT_pass() if $sequence eq "1NT-pass";
   return bid_ai_1NT_dbl()  if $sequence eq "1NT-dbl";
   return bid_ai_1NT_x()    if $sequence =~ /^1NT-\w+$/;
   return bid_ai_2NT_pass() if $sequence eq "2NT-pass";
   return bid_ai_2NT_dbl()  if $sequence eq "2NT-dbl";
   return bid_ai_2NT_x()    if $sequence =~ /^2NT-\w+$/;
   return bid_ai_xNT_y()    if $sequence =~ /^.NT-\w+$/;
   $open_suit = substr($bids[$turn_of_open],1,1);
   return bid_ai_1s_x()     if $sequence =~ /^1\w-\w+$/;
   return bid_ai_xs_x()     if $sequence =~ /^.\w-\w+$/;
   # left of opener's partner   (treat 1NT by parter like a opening 1NT bid)
   return bid_ai_1NT_pass() if $sequence =~ /^\w+-1NT-pass$/;  # treat 1NT overcall like 1NT open
   return bid_ai_1NT_dbl()  if $sequence =~ /^\w+-1NT-dbl$/; 
   return bid_ai_1NT_x()    if $sequence =~ /^\w+-1NT-\w+$/;  
   #return bid_ai_1s_x()     if $sequence =~ /^1(.)-\w+-\w+-\w+$/;    


       # FIXME
   # opener's rebid
   return "pass"                     if $sequence =~ /\w+-\w+-dbl-pass$/;    # if partner redoubled
   return "pass"                     if $sequence =~ /\w+-\w+-pass-\w+$/;    # if partner passed through
   return "pass"                     if $sequence =~ /1NT-\w+-pass-pass$/;   #  NBB
   return bid_ai_1NT_pass_2C_pass()  if $sequence =~ /1NT-\w+-2C-pass$/;     # Stayman!!!
   return "pass"                     if $sequence =~ /1NT-\w+-2.-pass$/;     # 
   return bid_ai_1NT_pass_2NT_pass() if $sequence =~ /1NT-\w+-2NT-pass$/;   
   return "pass"                     if $sequence =~ /1NT-\w+-[367]NT-pass$/;   # game
   return bid_ai_1NT_pass_4NT_pass() if $sequence =~ /1NT-\w+-4NT-pass$/;   
   return "pass"                     if $sequence =~ /1NT-\w+-4[HS]-pass$/;     # game
   return bid_ai_1NT_pass_5NT_pass() if $sequence =~ /1NT-\w+-5NT-pass$/;   
   return "pass"                     if $sequence =~ /1NT-\w+-5[CD]-pass$/;     # game
   return bid_ai_1NT_pass_x_pass($1,$2) if $sequence =~ /1NT-pass-(\d)(\w)-pass$/;   

   # rebidding after response to a Stayman
   return bid_ai_1NT_x_2C_x_2D()    if $sequence =~ /1NT-\w+-2C-\w+-2D-pass$/;     # Stayman!!!
   return bid_ai_1NT_x_2C_x_2j($1)  if $sequence =~ /1NT-\w+-2C-\w+-2([SH])-pass$/;     # Stayman!!!




   #garbage###return bid_ai_x_pass_x_pass() if $sequence =~ /^\w+-pass-\w+-pass$/;   
   #garbage###return bid_ai_x_x_x_x() if $sequence =~ /^\w+-\w+-\w+-\w+$/;   


   return "pass"; # FIXME
}

# AI = artificial intelligence
# This only only allows legal bids from bid_ai2()
sub bid_ai
{
   # Set up some ugly globals
   ($points,$honor_pts,$clubs,$diamonds,$hearts,$spades) = hand_points($bidder);
   %counts = ( "S" => $spades, "H" => $hearts, "D" => $diamonds, "C" => $clubs );
   @ordered = sort ($clubs, $hearts, $diamonds, $spades); # sort list of lengths
   print("bid_ai() bidder=$bidder points=$points honor_pts=$honor_pts c=$clubs d=$diamonds h=$hearts s=$spades\n") if $::debug;
   # Get the bid
   my $bid = bid_ai2();
   Carp::confess "bad bid $bid" if $bid ne "pass" && $bid ne "dbl" && $bid !~ /^\d[SDHC]$/i && $bid !~ /^\dNT$/;
   return "pass" if $bid =~ /^\d/ && $::contract =~ /^\d/ && ! can_bid($bid);   # if both begin with digit
   return $bid;
}

# This is called for all bids of all bidders.
sub place_bid
{
   my($bid) = @_;

   Carp::confess() if $passes_to_go <= 0;
   $bids[$turn] = $bid;
   my $label_key = substr($bidder,0,1) . $history_row;  # N2, E4, S5, etc.
   $bid_label{$label_key}->set($bid) if defined $bid_label{$label_key};  # update history display
   if($bid =~ /^\d/) {  # if bid begins with a number
      # update bid button insensitivity
      for(my $index = 0;$index <= $#bid_order;$index++) { # for every bid button
         $bid_button{$bid_order[$index]}->set_sensitive(0); # gray-out that bid button
         last if $bid_order[$index] eq $bid;  # stop at current bid
      }
      # update declarer
      my $who = $bidder;
      for(my $t = $turn;$t > 0;$t -= 2) {  # for all our teams bids in reverse order
         $decl = $who if(substr($bids[$t],1) eq substr($bid,1));  # if same suit
         $who = $::to_partner{$who};  # keep track of who made the bid
      }
      # update contract
      $::contract = $bid;
      $::double = 1;
   } 
   if($bid eq "pass") {  # if pass
      $passes_to_go--;
      if($passes_to_go <= 0) {  # if bidding closed
         my $dstars = ""; 
         $dstars = "*" if $::double > 1; 
         $dstars = "**" if $::double > 2;
         $::contract_label->set("Contract: $::contract$dstars by $::full_dir{$decl}");
         foreach (keys %bid_button) { $bid_button{$_}->set_sensitive(0) };  # gray-out bid buttons
         $hbox2->set_sensitive(0);  # hint, auto, pass, double
         $::status_label->set("Click Play.");
         return;
      };
   } else{  # else non-pass
      $passes_to_go = 3;  # party some more
      $passes_to_go = 0 if $bid eq "7NT";  # stop auction if 7NT is bid
      $turn_of_open = $turn_of_open || $turn;
   }
   if($bid eq "dbl") {
      $::double = ($::double == 2) ? 4 : 2;
   }
   $bidder = $::to_left{$bidder};
   $history_row++ if $bidder eq "W"; # wrap to next history row maybe
   $turn++;
   if($bidder ne "S" && $passes_to_go > 0) {  # for every computer player
      place_bid(bid_ai());
   }
   $bid_label{"S" . $history_row}->set("?") if($passes_to_go > 0);
   if($decl eq "N" || $decl eq "S") { # if redouble
      $double_button->child->parse_uline("Re_double");  
      $double_button->set_sensitive($::double == 2);  
   } else {  # else double
      $double_button->child->parse_uline("_Double");  
      $double_button->set_sensitive($::double < 2 && $::contract =~ /^\d/ || 0);  
   };
}

sub bid_button_press
{
   my($button,$name,$event) = @_;
   return if $bidder ne "S";  # ignore click when not our turn
   place_bid($name) if $passes_to_go > 0;
}

sub hint_clicked 
{ 
   return if $bidder ne 'S';
   my $label_key = substr($bidder,0,1) . $history_row;  # N2, E4, S5, etc.
   my $bid = "(". bid_ai() .")";
   $bid_label{$label_key}->set($bid) if defined $bid_label{$label_key};  # update history display
}
sub auto_clicked { place_bid(bid_ai()) if $bidder eq "S" && $passes_to_go > 0; }
sub pass_clicked { place_bid("pass") if $bidder eq "S" && $passes_to_go > 0; }
sub double_clicked 
{ 
   return if $bidder ne "S" || $passes_to_go <= 0;  # only bid if it is our turn
   return if $::contract !~ /^\d/;   # only double if someone has opened the bid
   if($decl eq "N" || $decl eq "S") {  # if we are redoubling
      return if $::double != 2;  # can only redouble a doubled contract 
      place_bid("rdbl");
   } else {  # else we are doubling
      return if $::double != 1;  # can only double a contract not yet doubled
      place_bid("dbl");
   }
}
sub redeal_clicked  
{ 
   $::dealer = $::to_right{$::dealer};
   deal::new_deal_now();
}

sub rebid_clicked 
{ 
   bid();
}
sub complete_clicked 
{ 
   while($passes_to_go > 0) {
      auto_clicked();
   }
}
sub play_clicked 
{
   complete_clicked();
   $::declarer = $decl;
   ::start_play();
}

my %dir_col = ( W=>0, N=>1, E=>2, S=>3 );

sub rotate_clicked   # counter-clockwise
{
   return if $bidder ne "S" && $passes_to_go > 0;  # ignore click when not our turn
   # rotate the hands
   foreach (@card::cards) {
      $::where{$_} = $::to_right{substr($::where{$_},0,1)} . substr($::where{$_},1);
   }
   $bidder = $::to_right{$bidder};
   $decl = $::to_right{$decl} if $decl;
   # fix the history labels in the bid dialog box
   $history_row = 2;
   my $bid_dir = "W";  # in the beginning...
   my $blanks = (401+$dir_col{$bidder}-$turn) %4;
   foreach my $bid (("") x $blanks, @bids, ("") x 4) {   # clean out a little extra on each side
      next if ! defined $bid;  # skip $bid[0]
      $bid_label{"$bid_dir$history_row"}->set($bid) if defined $bid_label{"$bid_dir$history_row"};
      $bid_dir = $::to_left{$bid_dir};
      $history_row++ if $bid_dir eq "W";
   };
   $history_row--;  # compensate for the four trailing blanks
   #
   ::expose_drawingareas();   # redraw the screen
   place_bid(bid_ai()) if $passes_to_go > 0;
}

# key is a key, and values are function pointers
my %keystroke = ( ); 

sub my_button 
{
   my($name,$func,@args) = @_;
   my $button = Gtk::Button->new($name); # child, yes expand, yes fill, 4 padding
   $button->child->parse_uline($name); # turn underscore to 
   $button->signal_connect('clicked', $func, @args) or die; 
   if($name =~ /_(.)/) {  # if keyboard shortcut
      die "kestroke=$1" if defined $keystroke{lc($1)};  # check for duplicate shortcut
      $keystroke{lc($1)} = $func;
   };
   return $button;
}

# Reset the game state and show the widget.
sub bid
{
   ::show_center('bid'); 
   # clear and enable
   foreach (values %bid_label) { $_->set("") };
   foreach (values %bid_button) { $_->set_sensitive(1) };
   $hbox2->set_sensitive(1);  # hint, auto, pass, double
   $double_button->set_sensitive(0);  
   # game state
   $::contract = "--";
   $::contract_label->set("Contract: --");
   $::double = 1;
   $bidder = $::dealer;
   $history_row = 2;  # Row 2 because 0 is labels and 1 is separator
   $passes_to_go = 4;  # Number of passes which would end bidding
   $turn = 1;
   $turn_of_open = 0;
   $::declarer = "";
   $decl = "";
   @bids = (undef);  # turn 1 is $bids[1] ($bids[0] is garbage)
   place_bid(bid_ai()) if $bidder ne "S";
   $bid_label{"S" . $history_row}->set("?");
   $bid_button{"1H"}->grab_focus();
   $::status_label->set("Click a Bid Button or Pass.");
   $::chosen_card = -1;
}

# Make and return the bidding widget which sits in the middle of the playfield, sometimes.
sub create_widgets
{
   my $align = Gtk::Alignment->new(0.5,0.5,0,0);  # centered with 0% expand
   # vertical box
   my $vbox = new Gtk::VBox( 0, 0 ); # non-homogenous, zero padding
   $align->add($vbox);
   # horizontal box for history and bid-buttons
   my $hbox1= new Gtk::HBox( 0, 0 ); # non-homogenous, zero padding
   $vbox->pack_start($hbox1,0,0,4); # child, no expand, no fill, 4 padding
   # left table (bidding history)
   my $history_table = Gtk::Table->new(8,4,0);  # 8 rows, 4 columsn, not homogenous
   $history_table->set_col_spacings(4);
   $history_table->attach_defaults(Gtk::Label->new("West"),0,1,0,1);
   $history_table->attach_defaults(Gtk::Label->new("North"),1,2,0,1);
   $history_table->attach_defaults(Gtk::Label->new("East"),2,3,0,1);
   $history_table->attach_defaults(Gtk::Label->new("South"),3,4,0,1);
   $history_table->attach_defaults(Gtk::HSeparator->new(),0,4,1,2);
   foreach (2..10) {  # for each possible row of bidding history
      $history_table->attach_defaults($bid_label{"W$_"} = Gtk::Label->new(""),0,1,$_,$_+1);
      $history_table->attach_defaults($bid_label{"N$_"} = Gtk::Label->new(""),1,2,$_,$_+1);
      $history_table->attach_defaults($bid_label{"E$_"} = Gtk::Label->new(""),2,3,$_,$_+1);
      $history_table->attach_defaults($bid_label{"S$_"} = Gtk::Label->new(""),3,4,$_,$_+1);
   };
   $hbox1->pack_start($history_table,0,0,4); # child, no expand, no fill, 4 padding
   # vertical separator
   $hbox1->pack_start(Gtk::VSeparator->new(),0,0,4); # child, no expand, no fill, 4 padding
   # right table (bidding buttons)
   my $button_table = Gtk::Table->new(7,5,1);  # 7 rows, 5 columsn, yes homogenous
   $button_table->set_col_spacings(4);
   $button_table->set_row_spacings(4);
   foreach (1..7) {  # for each row of bidding buttons
      $button_table->attach_defaults($bid_button{$_ ."C"}  = Gtk::Button->new($_ ."C") ,0,1,$_-1,$_);
      $button_table->attach_defaults($bid_button{$_ ."D"}  = Gtk::Button->new($_ ."D") ,1,2,$_-1,$_);
      $button_table->attach_defaults($bid_button{$_ ."H"}  = Gtk::Button->new($_ ."H") ,2,3,$_-1,$_);
      $button_table->attach_defaults($bid_button{$_ ."S"}  = Gtk::Button->new($_ ."S") ,3,4,$_-1,$_);
      $button_table->attach_defaults($bid_button{$_ ."NT"} = Gtk::Button->new($_ ."NT"),4,5,$_-1,$_);
   };
   $hbox1->pack_start($button_table,0,0,4); # child, no expand, no fill, 4 padding
   foreach my $name (keys %bid_button) {
      $bid_button{$name}->signal_connect('clicked', \&bid_button_press, $name ) or die; # plumb the buttons
   }
   # horizontal box for hint, undo, pass, double
   $hbox2= new Gtk::HBox( 1, 0 ); # yes-homogenous, zero padding
   $vbox->pack_start($hbox2,0,0,4); # child, no expand, no fill, 4 padding
   # hint, auto, pass, double row
   $hbox2->pack_start(my_button('_Hint',\&hint_clicked),1,1,4); # child, yes expand, yes fill, 4 padding
   $hbox2->pack_start(my_button('_Auto',\&auto_clicked),1,1,4); # child, yes expand, yes fill, 4 padding
   $hbox2->pack_start(my_button('_Pass',\&pass_clicked),1,1,4); # child, yes expand, yes fill, 4 padding
   $hbox2->pack_start($double_button = my_button('_Double',\&double_clicked),1,1,4); # child, yes expand, yes fill, 4 padding
   # horizontal box for hint, undo, pass, double
   my $hbox3= new Gtk::HBox( 1, 0 ); # yes-homogenous, zero padding
   $vbox->pack_start($hbox3,0,0,4); # child, no expand, no fill, 4 padding
   # rebid, redeal, complete, ??? row
   $hbox3->pack_start(my_button('Re_bid',\&rebid_clicked),1,1,4); # child, yes expand, yes fill, 4 padding
   $hbox3->pack_start(my_button('_Redeal',\&redeal_clicked),1,1,4); # child, yes expand, yes fill, 4 padding
   $hbox3->pack_start(my_button('Rotate _>>',\&rotate_clicked),1,1,4); # child, yes expand, yes fill, 4 padding
   $hbox3->pack_start(my_button('P_lay',\&play_clicked),1,1,4); # child, yes expand, yes fill, 4 padding
   # show me the money!
   $align->show_all();
   return ($align,\%keystroke);  # return list of two values
}



1;  # return value
