
# Copyright (c) 2003 Frederick Dean

use strict;

package deal;

# Gtk stuff
my $entry;  # for $dealnum
my %dealer_button;  # Gtk::Button  key of N, S, E, W
my %show_button;  # Gtk::Button  key of S, SN, SEW, SNEW
# Game state
my $dealnum = $ARGV[0] || int(rand(1000000000));
$dealnum--; 

sub update_statusbar
{
   ::conniption("illegal dealer") if ! defined $::full_dir{$::dealer};
   $::dealer_label->set("Deal: $::full_dir{$::dealer} $dealnum");
   foreach (keys %dealer_button) {
      $dealer_button{$_}->set_sensitive($::dealer ne $_);
   };
}

#  This shuffles and deals
#  It uses the globals and $dealnum
sub deal_cards
{ 
   my $hex = $dealnum;   
   my $ctx = Digest::Perl::MD5->new;
   my @deck = @card::cards;
   # shuffle
   foreach (0..51) {  # for each card
      $ctx->reset(); 
      $ctx->add($hex);
      $hex = $ctx->hexdigest();  # we call this a lot, but the performance affect is slight
      my $cut = hex(substr($hex,0,7)) % 52;  # pick a random card to swap with
      my $temp = splice(@deck,$cut,1,$deck[$_]);  # swap the two single cards
      splice(@deck,$_,1,$temp);
   };
   # deal
   my $who = $::to_left{substr($::dealer,0,1)};
   foreach (@deck) { 
      $::where{$_} = $who ."-";
      $who = $::to_left{$who};
   };
   # show it
   $::declarer = "";  # so the old dummy doesn't show
   $::trick = 0;  # so the cards don't show as end-of-game
   ::expose_drawingareas();
   update_statusbar();
   print("deal_cards() dealnum=$dealnum dealer=$::dealer\n") if $::debug;
}

sub west_dealer_clicked  { $::dealer = "W"; update_statusbar(); }
sub north_dealer_clicked  { $::dealer = "N"; update_statusbar(); }
sub east_dealer_clicked  { $::dealer = "E"; update_statusbar(); }
sub south_dealer_clicked  { $::dealer = "S"; update_statusbar(); }
sub bid_clicked { deal_num_entered_idle_task(); bid::bid(); }
sub play_clicked { deal_num_entered_idle_task(); bid::bid(); bid::play_clicked(); }
sub next_clicked 
{ 
   $dealnum++; 
   $entry->set_text($dealnum);
   deal_cards(); 
}
sub prev_clicked 
{ 
   $dealnum--; 
   $entry->set_text($dealnum);
   deal_cards(); 
}

sub show_clicked  
{ 
   $::show_hands = $_[0]; 
   ::expose_drawingareas();
   foreach (keys %show_button) {
      $show_button{$_}->set_sensitive($_ ne $::show_hands);
   };
}
sub show_mine_clicked  { show_clicked("S") }
sub show_ew_clicked  { show_clicked("SEW") }
sub show_north_clicked  { show_clicked("SN") }
sub show_all_clicked  { show_clicked("SNEW") }

sub rotate_ccw_clicked   # counter-clockwise
{
   foreach (@card::cards) {
      $::where{$_} = $::to_right{substr($::where{$_},0,1)} . substr($::where{$_},1);
   }
   ::expose_drawingareas();   # redraw the screen
}
sub rotate_cw_clicked   # clockwise
{
   foreach (@card::cards) {
      $::where{$_} = $::to_left{substr($::where{$_},0,1)} . substr($::where{$_},1);
   }
   ::expose_drawingareas();   # redraw the screen
}

# key is a key, and values are function pointers
my %keystroke = ( "-" => \&prev_clicked, "=" => \&next_clicked, "+" => \&next_clicked ); 

sub my_button 
{
   my($name,$func) = @_;
   my $button = Gtk::Button->new($name); # child, yes expand, yes fill, 4 padding
   $button->child->parse_uline($name); # turn underscore to 
   $button->signal_connect('clicked', $func) or die; 
   if($name =~ /_(.)/) {  # if keyboard shortcut
      die "keystroke=$1" if defined $keystroke{lc($1)};  # check for duplicate shortcut
      $keystroke{lc($1)} = $func;
   };
   return $button;
}

my $idle_tag;  # This is really ugly.  We need to use an idle task so it runs _after_ the text update.
sub deal_num_entered_idle_task  
{
   Gtk->idle_remove($idle_tag) if defined $idle_tag;
   $idle_tag = undef;
   my $old_dealnum = $dealnum;
   $dealnum = $entry->get_text();   # FIXME this gets the old value!!
   $dealnum =~ s/\D//g;  # delete non numbers
   deal_cards() if $dealnum && $dealnum != $old_dealnum;
}
sub deal_num_entered 
{ 
   #my($entry,$event) = @_;
   #print "deal_num_entered() ". join(" - ",@_) ." (type=${$event}{'type'})\n";
   #print map { "   $_ => ". ${$event}{$_} ."\n" } sort keys %$event;
   $idle_tag = Gtk->idle_add(\&deal_num_entered_idle_task) if ! defined $idle_tag; 
   return 0;
}

sub new_deal_now
{
   $dealnum++;
   $entry->set_text($dealnum);
   $::dealer = $::to_left{$::dealer};
   deal_cards();
   bid::bid();
}

sub interactive_deal
{
   $dealnum++;
   $entry->set_text($dealnum);
   $::dealer = $::to_left{$::dealer};
   deal_cards();
   ::show_center('deal'); 
   foreach (keys %show_button) {
      $show_button{$_}->set_sensitive($_ ne $::show_hands);
   };
   $::status_label->set("Click Bid.");
}

# Make and return the bidding widget which sits in the middle of the playfield, sometimes.
sub create_widgets
{
   my $align = Gtk::Alignment->new(0.5,0.5,0,0);  # centered with 0% expand
   # vertical box
   my $vbox = new Gtk::VBox( 0, 0 ); # non-homogenous, zero padding
   $align->add($vbox);
   # horizontal box & frame for deal number
   my $frame1 = Gtk::Frame->new("Deal Number:");
   $vbox->pack_start($frame1,0,0,4); # child, no expand, no fill, 4 padding
   my $hbox1= new Gtk::HBox( 1, 0 ); # yes-homogenous, zero padding
   $frame1->add($hbox1);
   # deal number row
   $entry = Gtk::Entry->new_with_max_length(10);
   $entry->signal_connect('key_press_event', \&deal_num_entered) or die; 
   $hbox1->pack_start($entry,1,1,4); # child, yes expand, yes fill, 4 padding
   my $hbox1a= new Gtk::HBox( 1, 0 ); # yes-homogenous, zero padding
   $hbox1->pack_start($hbox1a,1,1,4); # child, yes expand, yes fill, 4 padding
   $hbox1a->pack_start(my_button('Nex_t',\&next_clicked),1,1,4); # child, yes expand, yes fill, 4 padding
   $hbox1a->pack_start(my_button('Pre_v',\&prev_clicked),1,1,4); # child, yes expand, yes fill, 4 padding
   # horizontal box for 
   my $frame4 = Gtk::Frame->new("Show Hands:");
   $vbox->pack_start($frame4,0,0,4); # child, no expand, no fill, 4 padding
   my $hbox4= new Gtk::HBox( 1, 0 ); # yes-homogenous, zero padding
   $frame4->add($hbox4);
   # show hands buttons
   $hbox4->pack_start($show_button{"S"}    = my_button('Only _Mine',\&show_mine_clicked,"S"),1,1,4); # child, yes expand, yes fill, 4 padding
   $hbox4->pack_start($show_button{"SEW"}  = my_button('E&W',\&show_ew_clicked,"SEW"),1,1,4); # child, yes expand, yes fill, 4 padding
   $hbox4->pack_start($show_button{"SN"}   = my_button('North',\&show_north_clicked,"SN"),1,1,4); # child, yes expand, yes fill, 4 padding
   $hbox4->pack_start($show_button{"SNEW"} = my_button('_All',\&show_all_clicked,"SNEW"),1,1,4); # child, yes expand, yes fill, 4 padding
   # horizontal box & frame for dealer
   my $frame2 = Gtk::Frame->new("Dealer:");
   $vbox->pack_start($frame2,0,0,4); # child, no expand, no fill, 4 padding
   my $hbox2= new Gtk::HBox( 1, 0 ); # yes-homogenous, zero padding
   $frame2->add($hbox2);
   # hint, auto, pass, double row
   $hbox2->pack_start($dealer_button{'W'} = my_button('_West',\&west_dealer_clicked),1,1,4); # child, yes expand, yes fill, 4 padding
   $hbox2->pack_start($dealer_button{'N'} = my_button('_North',\&north_dealer_clicked),1,1,4); # child, yes expand, yes fill, 4 padding
   $hbox2->pack_start($dealer_button{'E'} = my_button('_East',\&east_dealer_clicked),1,1,4); # child, yes expand, yes fill, 4 padding
   $hbox2->pack_start($dealer_button{'S'} = my_button('_South',\&south_dealer_clicked),1,1,4); # child, yes expand, yes fill, 4 padding
   # horizontal box for hint, undo, pass, double
   my $hbox3= new Gtk::HBox( 1, 0 ); # yes-homogenous, zero padding
   $vbox->pack_start($hbox3,0,0,4); # child, no expand, no fill, 4 padding
   # rebid, redeal, complete, ??? row
   $hbox3->pack_start(my_button('_<< Rotate',\&rotate_cw_clicked),1,1,4); # child, yes expand, yes fill, 4 padding
   $hbox3->pack_start(my_button('Rotate >_>',\&rotate_ccw_clicked),1,1,4); # child, yes expand, yes fill, 4 padding
   $hbox3->pack_start(my_button('_Bid',\&bid_clicked),1,1,4); # child, yes expand, yes fill, 4 padding
   $hbox3->pack_start(my_button('P_lay',\&play_clicked),1,1,4); # child, yes expand, yes fill, 4 padding
   # show me the money!
   $align->show_all();
   return ($align,\%keystroke);  # return list of two values
}

1;  # return value
