
# Copyright (c) 2003 Frederick Dean

use strict;

package history;

my $history_window;
my %turn_label;  #  key is W1, E2, N13, etc.

sub erase_trick_and_after
{
   my($tr) = @_;

   #print("erase_trick_and_after() tr=$tr\n") if $::debug;
   return if ! defined $history_window;
   return if $tr > 13;
   $tr = 1 if $tr < 1;
   foreach my $t ($tr..13) {
      foreach my $dir (qw/N S E W/) {
         $turn_label{ "$dir$t" }->set("");  # clear out the label 
      }; 
   }
}


sub report_turn
{
   my($card,$trick,$who) = @_;
   #print("report_turn() card=$card trick=$trick who=$who\n") if $::debug;
   ::conniption() if $trick < 1 || $trick > 13 || ! $who || length $card != 2;
   return if ! defined $history_window;
   $card = substr($card,1,1) . substr($card,0,1);  # swap chars
   $card =~ s/^T/10/;
   $card .= "*" if $::lead[$trick] eq $who;
   $turn_label{ $who . $trick}->set($card); 
#$turn_label{ $who . $trick}->window->set_background({ red=>1000, green=>1000, blue=>60000, pixel=>0} );  # FIXME
}

sub delete_event { $history_window->destroy(); $history_window = undef; }
sub close_clicked { delete_event(); }

my %keystroke;

sub do_key_press_event 
{ 
   my($widget,$event) = @_;
   #print map { "   $_ -> " . $$event{$_} ."\n"} keys %$event;
   if(defined $$event{'string'} && defined $keystroke{$$event{'string'}}) { 
      &{$keystroke{$$event{'string'}}}; # call %keystroke function if defined
      return undef;
   } else {
      return ::do_key_press_event(@_);  # pass keystroke on to main window
   };
}

sub my_button 
{
   my($name,$func) = @_;
   my $button = Gtk::Button->new($name); # child, yes expand, yes fill, 4 padding
   $button->child->parse_uline($name); # turn underscore to 
   $button->signal_connect('clicked', $func); 
   if($name =~ /_(.)/) {  # if keyboard shortcut
      #die "kestroke=$1" if defined $keystroke{lc($1)};  # check for duplicate shortcut
      $keystroke{lc($1)} = $func;
   };
   return $button;
}

sub open_window
{
   return if defined $history_window;  # don't create if already exists
   $history_window = new Gtk::Window( 'dialog' );
   $history_window->title("History of Play");
   $history_window->set_policy(0,0,0);  # no allow_shrink, no allow_grow, no auto_shrink
   $history_window->set_default_size(500,400);
   $history_window->signal_connect('delete_event', \&delete_event ) or die; # quit on main window close
   $history_window->signal_connect('key_press_event', \&do_key_press_event ) or die; 
   $history_window->border_width(4);
   $history_window->set_transient_for($::main_window); 
   # vertical box
   my $vbox = new Gtk::VBox( 0, 0 ); # non-homogenous, zero padding
   $history_window->add($vbox);  
   # Main table
   my $history_table = Gtk::Table->new(15,5,0);  # 8 rows, 4 columsn, not homogenous
   $history_table->set_col_spacings(4);
   $history_table->attach_defaults(Gtk::Label->new("West"),1,2,0,1);
   $history_table->attach_defaults(Gtk::Label->new("North"),2,3,0,1);
   $history_table->attach_defaults(Gtk::Label->new("East"),3,4,0,1);
   $history_table->attach_defaults(Gtk::Label->new("South"),4,5,0,1);
   $history_table->attach_defaults(Gtk::HSeparator->new(),1,5,1,2);
   foreach (1..13) {  # for each possible row of bidding history
      $history_table->attach_defaults(Gtk::Label->new($_),0,1,$_+1,$_+2);
      $history_table->attach_defaults($turn_label{"W$_"} = Gtk::Label->new(""),1,2,$_+1,$_+2);
      $history_table->attach_defaults($turn_label{"N$_"} = Gtk::Label->new(""),2,3,$_+1,$_+2);
      $history_table->attach_defaults($turn_label{"E$_"} = Gtk::Label->new(""),3,4,$_+1,$_+2);
      $history_table->attach_defaults($turn_label{"S$_"} = Gtk::Label->new(""),4,5,$_+1,$_+2);
   };
   $vbox->pack_start($history_table,0,0,4); # child, no expand, no fill, 4 padding
   # legend
   $vbox->pack_start(Gtk::Label->new('* indicates lead'),1,1,4); # child, yes expand, yes fill, 4 padding
   # okay button
   $vbox->pack_start(my_button('_Close',\&close_clicked),1,1,4); # child, yes expand, yes fill, 4 padding
   # populate the labels
   foreach my $c (@card::cards) {  # for each card
      my $w = $::where{$c};        # determine where it is
      report_turn($c,substr($w,1),substr($w,0,1)) if substr($w,1) ne "-";  # report it if played
   }
   # show me the money!
   #Gtk->main_iteration while ( Gtk->events_pending );
   $history_window->show_all();
}



1;  # return value
