#!/usr/bin/perl -w
use strict;

# Copyright (c) 2003 Frederick Dean

my $path = "images";

print qq{
#  comment lines begin with '#'
#
#  '*' for a value means use default.
#
#  Cards have two letter names.
#
#  a=ace      c=clubs
#  2=2        d=diamonds
#  3=3        h=hearts
#  4=4        s=spaces
#  t=10
#  j=jack
#  q=queen
#  k=king
#
#
card back
image $path/blank-card.png 0 0 0 0 79 123
image $path/beige.png 0 0 0 0 79 123
special $path/special-card.png 0 0 0 0 79 123
};

my %dorkx = ( "j" => 0, "q" => 47, "k" => 94);

my $facex = 0;
foreach my $face (qw/a 2 3 4 5 6 7 8 9 t j q k/) {
   $facex += 9;
   my $suitx = 0;
   foreach my $suit (qw/c d h s/) {
      print("card $suit$face\n");
      print("image $path/blank-card.png 0 0 0 0 79 123\n");
      my $ny = 0;
      $ny = "14" if $suit eq "d" || $suit eq "h";
      print("image $path/bold-09x14.png ". ($facex) ." $ny 3 5 9 14\n");   # number
      print("image $path/bold-09x14-180.png ". (117-$facex) ." ". (14-$ny) ." 67 104 9 14\n");   # bottom number 
      print("image $path/knuth-09x10.png ". ($suitx * 9) ." 0 3 24 9 10\n");  # suit under number
      print("image $path/knuth-09x10-180.png ". (27 - $suitx * 9) ." 0 67 89 9 10\n");  # bottom suit under number
      print("image $path/bonded.png ". ($suitx*49) ." ". $dorkx{$face} ." 15 15 49 47\n") if defined $dorkx{$face}; # face
      print("image $path/bonded180.png ". (147-$suitx*49) ." ". (94-$dorkx{$face}) ." 15 62 49 47\n") if defined $dorkx{$face}; # face
      print("image $path/knuth-21x25.png ". ($suitx * 21) ." 0 30 47 21 25\n") if $face eq "a";  # ace center
      $suitx += 1;
   };
}


