
use strict;

package pbn;

sub error
{
   my($msg) = @_;
   my $label1= Gtk::Label->new($msg);
   require about;
   about::ok_box('Error, OpenBridge',500,400,$label1);
}

# This generate the deal in a one line format.
sub compose_deal
{
   my $who = $::dealer;  # write dealer first
   my $deal = substr($who,0,1) . ":";
   do {  # for each player (i.e. hand)
      foreach my $suit (qw/S H D C/) {
         foreach my $rank (qw/A K Q J T 9 8 7 6 5 4 3 2/) {
            $deal .= $rank if substr($::where{$suit . $rank},0,1) eq $who;
         };
         $deal .= ".";  # add dot inbetween suits
      }
      chop($deal);  # remove the trailing period
      $deal .= " ";  # add space inbetween hands
      $who = $::to_left{$who};
   } while ($who ne $::dealer);
   chop($deal);  # remove the trailing space
   return $deal;
}

my %translate = ( pass => "Pass", dbl => "X", rdbl => "XX" );

sub pbn_bid_string 
{ 
   my $string = ""; 
   my @b = @bid::bids[1..$#bid::bids];  # skip list element zero
   push(@b,"+") if scalar(@b) < 4 || $b[-1] ne "pass" || $b[-2] ne "pass" || $b[-3] ne "pass";  # if incomplete
   while(scalar @b) {   # while we have bids to write
      foreach (1,2,3,4) {   # for each bid position on the line
         my $bid = shift(@b) || "";
         $bid = $translate{$bid} if $translate{$bid};
         $string .= sprintf("%-6s",$bid) 
      };
      $string .= "\n";
   }
   return $string;
}


# This function does not check if the file exists.
# It doesn't remember what the last deal was.
# Given a filename, it simply writes.
sub save_file
{
   my($filename) = @_;
   defined $filename or return error("Internal Error:\nSave filename undefined!");
   local(*OUT);
   open(OUT,">>$filename") or return error("Cannot open $filename \n$!");
   my($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime();
   my $deal = compose_deal();
   my $declarer = "[Declarer \"$::declarer\"]\n" if $::declarer; 
   my $contract = "[Contract \"$::contract\"]\n" if $::declarer; # not a typo, $::declarer indicate bidding close
   print(OUT "% PBN 2.0\n".
             "% EXPORT\n".
             "[Event \"OpenBridge Game\"]\n".
             "[Date ".  sprintf("%4d.%02d.%02d",$year+1900,$mon+1,$mday) . "]\n".
             "[West \"West\"]\n".
             "[North \"North\"]\n".
             "[East \"East\"]\n".
             "[South \"South\"]\n".
             "[Dealer \"$::dealer\"]\n".
             "[Vulnerable \"None\"]\n".
             "[Deal \"$deal\"]\n".
             "[Scoring \"IMP\"]\n".
              ($declarer || "") .
              ($contract || "") .
             "[Auction \"$::dealer\"]\n".
              pbn_bid_string());
   if($::declarer) {
      print(OUT "[Play \"$::declarer\"]\n");
      my $who = $::declarer;
      for(my $trick = 1;$trick < 14 && $trick <= $::trick+1;$trick++) {
         printf(OUT "%-3s%-3s%-3s%-3s\n",::played($::declarer . $trick)                || "-",
                                         ::played($::to_left{$::declarer} . $trick)    || "-",
                                         ::played($::to_partner{$::declarer} . $trick) || "-", 
                                         ::played($::to_right{$::declarer} . $trick)   || "-");
      } 
      print(OUT "*\n") if $::trick < 12;
   };
   print(OUT "\n");
   close(OUT);
}

my $savename = "untitled.pbn";

sub do_save_ok
{
   my($button,$fs) = @_;
   $savename = $fs->get_filename();
   save_file($savename);
   $fs->destroy;
}

sub do_save
{
   save_file("-") if $::debug;
   my $fs = Gtk::FileSelection->new("OpenBridge Save PBN File");
   #$fs->complete("*.pbn");  #  
   $fs->set_filename($savename);
   $fs->cancel_button->signal_connect('clicked', sub { $fs->destroy() } ) or die; # quit on main window close
   $fs->ok_button->signal_connect('clicked', \&do_save_ok, $fs ) or die; # quit on main window close
   $fs->show();
}

1;  # return value

__END__

From pbn_v20.txt

[Event "International Amsterdam Airport Schiphol Bridgetournament"]
[Site "Amsterdam, The Netherlands NLD"]
[Date "1995.06.10"]
[Board "1"]
[West "Podgor"]
[North "Westra"]
[East "Kalish"]
[South "Leufkens"]
[Dealer "N"]
[Vulnerable "None"]
[Deal "N:.63.AKQ987.A9732 A8654.KQ5.T.QJT6 J973.J98742.3.K4 KQT2.AT.J6542.85"]
[Scoring "IMP"]
[Declarer "S"]
[Contract "5HX"]
[Result "9"]
{
                S
                H 6 3
                D A K Q 9 8 7
                C A 9 7 3 2
S K Q 10 2                      S A 8 6 5 4
H A 10                          H K Q 5
D J 6 5 4 2                     D 10
C 8 5                           C Q J 10 6
                S J 9 7 3
                H J 9 8 7 4 2
                D 3
                C K 4   
}
[Auction "N"]
1D      1S   3H =1= 4S
4NT =2= X    Pass   Pass
5C      X    5H     X
Pass    Pass Pass
[Note "1:non-forcing 6-9 points, 6-card"]
[Note "2:two colors: clubs and diamonds"]
[Play "W"]
SK =1= H3 S4 S3
C5 C2 C6 CK
S2 H6 S5 S7
C8 CA CT C4
D2 DA DT D3
D4 DK H5 H7
-  -  -  H2
*
[Note "1:highest of series"]


