
# Copyright (c) 2003 Frederick Dean

use strict;

package play_ai;

sub play_turn_ai
{
   my $chosen_card = 0;
   my $play_low_flag = ($::lead[$::trick] eq $::whos_turn) || ($::lead[$::trick] eq $::to_right{$::whos_turn}) ||  # if opening or playing second
      ($::lead[$::trick+1] && $::lead[$::trick+1] eq $::to_partner{$::whos_turn});  # or our partner has it, then play low
   my @hand = ::sorted_hand($::whos_turn);
   #print "play_turn_ai() whos_turn=$::whos_turn lead_suit=$::lead_suit trick=$::trick\n" if $::debug; 
   if($::lead_suit && scalar(grep { substr($_,0,1) eq $::lead_suit } @hand)) {  # if we have to follow suit
      if($play_low_flag) {
         $chosen_card = $#hand;
         while(substr($hand[$chosen_card],0,1) ne $::lead_suit) {
           $chosen_card--;
         };
      } else {  # else play high
         $chosen_card = 0;
         while(substr($hand[$chosen_card],0,1) ne $::lead_suit) {
           $chosen_card++;
         };
      };
   } else {  # else don't follow suit
      $chosen_card = $#hand if $play_low_flag;
   };
#print "play_turn_ai() chosen_card=$chosen_card\n";
   return $hand[$chosen_card];  
}


1;

