
use strict;

package score;

# Gtk stuff
my %label;  # key is 2we, 3they, 3they
my $num_rows = 12;


sub rebid_clicked 
{ 
   ::undo_to_trick(0);
}
sub replay_clicked 
{
   ::show_center('play');
   ::undo_to_trick(1);
}

# key is a key, and values are function pointers
my %keystroke = ( "b" => \&deal::new_deal_now ); 

sub my_button 
{
   my($name,$func,@args) = @_;
   my $button = Gtk::Button->new($name); # child, yes expand, yes fill, 4 padding
   $button->child->parse_uline($name); # turn underscore to 
   $button->signal_connect('clicked', $func, @args) or die; 
   if($name =~ /_(.)/) {  # if keyboard shortcut
      die "kestroke=$1" if defined $keystroke{lc($1)};  # check for duplicate shortcut
      $keystroke{lc($1)} = $func;
   };
   return $button;
}

my %team = ( N => "we", S => "we", E => "they", W => "they" );
my %oppo = ( we => "they", they => "we" );
my %below_worth = ( C => 20, D => 20, H => 30, S => 30, NT => 30 );
my @undertrick_nv_dbl = [ 100, 300, 500, 800, 1100, 1400 ];

# Reset the game state and show the widget.
sub score
{
   foreach (values %label) { $_->set(" "); };
   my $vulnerable = 0;
   if($::contract =~ /^(\d)(.+)/) {  # if it was not all pass
      my($need,$suit) = ($1,$2);
      my $decl = $team{$::declarer};
      my $made = ($decl eq "we") ? $::ns_tricks : $::ew_tricks;
      if($made >= $need + 6) {  # if the declarer made the contract
         my $below = $need * $below_worth{$suit};    
         $below += 10 if $suit eq "NT";
         $below *= $::double;
         $label{($num_rows/2+1) . $decl}->set($below);
         if($made > $need + 6) {  # if we made more than we needed
            my $rate = $below_worth{$suit};
            $rate = 100 if $::double == 2;
            $rate = 200 if $::double > 2;  # if redoubled
            $rate *= 2 if $::double >= 2 && $vulnerable;  # if redoubled and vulnerable
            my $above = ($made - $need - 6) * $rate;
            $label{($num_rows/2-1) . $decl}->set($above);
         }
         $label{($num_rows/2-2) . $decl}->set("50") if $::double == 2;  # insult
         $label{($num_rows/2-2) . $decl}->set("100") if $::double > 2;  # insult
         $label{($num_rows/2-3) . $decl}->set($vulnerable?"500":"750") if $need == 6;  # small slam
         $label{($num_rows/2-3) . $decl}->set($vulnerable?"1000":"1500") if $need == 7;  # grand slam
      } else {  # else the contract was not achieved
         my $missed = $need + 6 - $made;
         my $bonus = ($missed * 50);  # not vulnerable and not doubled
         $bonus = ($missed * 100) if $vulnerable;
         $bonus = $undertrick_nv_dbl[$missed] if ! $vulnerable && $::double >= 2;
         $bonus = $missed * 300 - 100 if $vulnerable && $::double >= 2;
         $bonus *= 2 if $::double > 2;  # if redoubled
         $label{($num_rows/2-1) . $oppo{$decl}}->set($bonus);
      } 
      $::status_label->set("I could have done better.");
   } else {
      $::status_label->set("You gutless wimp.");
   }
   ::show_center('score'); 
}

# Make and return the bidding widget which sits in the middle of the playfield, sometimes.
sub create_widgets
{
   my $align = Gtk::Alignment->new(0.5,0.5,0,0);  # centered with 0% expand
   # vertical box
   my $vbox = new Gtk::VBox( 0, 0 ); # non-homogenous, zero padding
   $align->add($vbox);
   # table
   my $table = Gtk::Table->new($num_rows,3,0);  # 12 rows, 3 columsn, not homogenous
   $table->set_col_spacings(1);
   $table->attach_defaults(Gtk::Label->new("     We       "),0,1,0,1);
   $table->attach_defaults(Gtk::VSeparator->new(),1,2,0,$num_rows);
   $table->attach_defaults(Gtk::Label->new("    They    "),2,3,0,1);
   #foreach (1..$num_rows/2 , ($num_rows/2)+1..$num_rows-1) {
   foreach (1..$num_rows-1) {
      $table->attach_defaults($label{$_ ."we"} = Gtk::Label->new(" "),0,1,$_,$_+1); 
      $table->attach_defaults($label{$_ ."they"} = Gtk::Label->new(" "),2,3,$_,$_+1); 
   };
   $table->attach_defaults(Gtk::HSeparator->new(),0,3,$num_rows/2,($num_rows/2)+1);
   my $align2 = Gtk::Alignment->new(0.5, 0.5, 0.0, 0.5);  # centered, no vertical expansion, half horiz expansion
   $align2->add($table);
   $vbox->pack_start($align2,0,0,4); # child, no expand, no fill, 4 padding
   # horizontal box for hint, undo, pass, double
   my $hbox2= Gtk::HBox->new( 1, 0 ); # yes-homogenous, zero padding
   $vbox->pack_start($hbox2,0,0,4); # child, no expand, no fill, 4 padding
   # hint, auto, pass, double row
   $hbox2->pack_start(my_button('_Undo',\&::do_undo),1,1,4); # child, yes expand, yes fill, 4 padding
   $hbox2->pack_start(my_button('_Rebid',\&rebid_clicked),1,1,4); # child, yes expand, yes fill, 4 padding
   $hbox2->pack_start(my_button('Re_play',\&replay_clicked),1,1,4); # child, yes expand, yes fill, 4 padding
   $hbox2->pack_start(my_button('Next _Deal',\&deal::interactive_deal),1,1,4); # child, yes expand, yes fill, 4 padding
   $hbox2->pack_start(my_button('_Next _Bid',\&deal::new_deal_now),1,1,4); # child, yes expand, yes fill, 4 padding
   # show me the money!
   $align->show_all();
   return ($align,\%keystroke);  # return list of two values
}

1;  # return value
