
#include <assert.h>
#include <stdlib.h>
#include "huffman.h"
#include "bitfile.h"
 
struct HuffmanTableStruct {
   int tableEntryCount;
   int longestLength;
   HuffmanTableEntry *rawTablePtr;
};
 
/* This is totally non-optimized, but could be replaced with a table lookup facility */
HuffmanTable *NewHuffmanTable(HuffmanTableEntry *rawTablePtr,int tableEntryCount)
{
   int j,k,bitLengthDiff,longestPrefixLength;
   HuffmanTable *newHuffmanTablePtr;

#ifndef NDEBUG
   /* for each pair of entries */
   for(j=0;j<tableEntryCount;j++) {
      for(k=j+1;k<tableEntryCount;k++) {
         assert(rawTablePtr[j].decodeValue != rawTablePtr[k].decodeValue); /*assert unique decode */
         bitLengthDiff = rawTablePtr[j].bitLength - rawTablePtr[k].bitLength;
         if(bitLengthDiff >= 0)
            assert((rawTablePtr[j].code>>bitLengthDiff) != rawTablePtr[k].code);/*assert no prefixes*/
         else
            assert(rawTablePtr[j].code != (rawTablePtr[k].code>>-bitLengthDiff));
      };
      assert(rawTablePtr[j].bitLength > 0 && rawTablePtr[j].bitLength < 33); /* assert sane bitLength */
      assert((rawTablePtr[j].code >> rawTablePtr[j].bitLength) == 0);/*assert code shorter than bitLength*/
   };
#endif
   longestPrefixLength = 0;
   for(j=0;j<tableEntryCount;j++)  /* for every code */
      if(rawTablePtr[j].bitLength > longestPrefixLength)
         longestPrefixLength = rawTablePtr[j].bitLength;  /* keep track of the longest */
   newHuffmanTablePtr = (HuffmanTable*) malloc(sizeof(HuffmanTable));
   newHuffmanTablePtr->longestLength = longestPrefixLength;
   newHuffmanTablePtr->tableEntryCount = tableEntryCount;
   newHuffmanTablePtr->rawTablePtr = rawTablePtr;
   return newHuffmanTablePtr;
}

/* The return value is the decode value */
int ReadHuffmanCode(BitFile *bitFilePtr,HuffmanTable *huffmanTablePtr,char *commentStr)
{
   unsigned int bits; 
   int j;
   HuffmanTableEntry *huffmanEntryPtr;

   assert(huffmanTablePtr);
   assert(huffmanTablePtr->longestLength > 0 && huffmanTablePtr->longestLength < 32);
   assert(huffmanTablePtr->tableEntryCount > 0 && huffmanTablePtr->tableEntryCount < 1000);
   assert(huffmanTablePtr->rawTablePtr);
   huffmanEntryPtr = huffmanTablePtr->rawTablePtr;
   bits = BitFilePeekBits(bitFilePtr,huffmanTablePtr->longestLength,NULL);
   for(j=0;j<huffmanTablePtr->tableEntryCount;j++)  /* for every code */
      if(huffmanEntryPtr[j].code == (bits >> (huffmanTablePtr->longestLength - huffmanEntryPtr[j].bitLength))){
         BitFileReadBits(bitFilePtr,huffmanEntryPtr[j].bitLength,commentStr);
         return huffmanEntryPtr[j].decodeValue;
      };
   return HUFFMAN_ERROR;
}


                                                                                                                                  


