
#include <assert.h>
#include "huffman.h"
#include "table.h"

/*  bitLength,code,decodeValue */

/* decode value is addressing increment */
HuffmanTableEntry rawMbAddressing[] = { 
   {1,1,1},
   {3,3,2},
   {3,2,3},
   {4,3,4},
   {4,2,5},
   {5,3,6},
   {5,2,7},
   {7,7,8},
   {7,6,9},
   {8,11,10},
   {8,10,11},
   {8,9,12},
   {8,8,13},
   {8,7,14},
   {8,6,15},
   {10,23,16},
   {10,22,17},
   {10,21,18},
   {10,20,19},
   {10,19,20},
   {10,18,21},
   {11,35,22},
   {11,34,23},
   {11,33,24},
   {11,32,25},
   {11,31,26},
   {11,30,27},
   {11,29,28},
   {11,28,29},
   {11,27,30},
   {11,26,31},
   {11,25,32},
   {11,24,33},
   {11,8,34}};

 /* decode value is bit field:  0xf00  permitted spatial_temporal_weight_classes */
 /*                             0x020  macroblock_quant */
 /*                             0x010  macroblock_motion_forward */
 /*                             0x008  macroblock_motion_backward */
 /*                             0x004  macroblock_pattern */
 /*                             0x002  macroblock_intra */
 /*                             0x001  spatial_temporal_weight_code_flag */
HuffmanTableEntry rawMbTypeForI[] = { 
   {1,1,0x002},
   {2,1,0x022}};

HuffmanTableEntry rawMbTypeForP[] = { 
   {1,1,0x014},
   {2,1,0x004},
   {3,1,0x010},
   {5,3,0x002},
   {5,2,0x034},
   {5,1,0x024},
   {6,1,0x022}};

static HuffmanTableEntry rawMbTypeForB[] = { 
   {2,2,0x018},
   {2,3,0x01c},
   {3,2,0x008},
   {3,3,0x00c},
   {4,2,0x010},
   {4,3,0x014},
   {5,3,0x002},
   {5,2,0x03c},
   {6,3,0x034},
   {6,2,0x02c},
   {6,1,0x022}};

static HuffmanTableEntry rawMbTypeForISpatial[] = { 
   {1,1,0x808},
   {2,1,0x828},
   {4,3,0x002},
   {4,2,0x022},
   {4,1,0x800}};

static HuffmanTableEntry rawMbTypeForPSpatial[] = { 
   {2,2,0x014},
   {3,3,0x715},
   {7,4,0x004},
   {6,7,0x705},
   {4,2,0x010},
   {7,7,0x002},
   {4,3,0x711},
   {3,2,0x034},
   {6,4,0x024},
   {7,6,0x023},
   {2,3,0x731},
   {6,5,0x721},
   {6,6,0x701},
   {7,5,0x840},
   {7,2,0x820},
   {7,3,0x800}};


static HuffmanTableEntry rawMbTypeForBSpatial[] = { 
   {2,2,0x018},
   {2,3,0x01c},
   {3,2,0x008},
   {3,3,0x00c},
   {4,2,0x010},
   {4,3,0x014},
   {6,6,0x709},
   {6,7,0x70d},
   {6,4,0x711},
   {6,5,0x715},
   {7,6,0x002},
   {7,7,0x03c},
   {7,4,0x034},
   {7,5,0x02c},
   {8,4,0x022},
   {8,5,0x735},
   {9,12,0x72d},
   {9,14,0x800},
   {9,13,0x824},
   {9,15,0x804}};

/* decode value is cbp */
static HuffmanTableEntry rawCodedBlockPattern[] = { 
   {3,0x07,60},
   {4,0x0d,4},
   {4,0x0c,8},
   {4,0x0b,16},
   {4,0x0a,32},
   {5,0x13,12},
   {5,0x12,48},
   {5,0x11,20},
   {5,0x10,40},
   {5,0x0f,28},
   {5,0x0e,44},
   {5,0x0d,52},
   {5,0x0c,56},
   {5,0x0b,1},
   {5,0x0a,61},
   {5,0x09,2},
   {5,0x08,62},
   {6,0x0f,24},
   {6,0x0e,36},
   {6,0x0d,3},
   {6,0x0c,63},
   {7,0x17,5},
   {7,0x16,9},
   {7,0x15,17},
   {7,0x14,33},
   {7,0x13,6},
   {7,0x12,10},
   {7,0x11,18},
   {7,0x10,34},
   {8,0x1f,7},
   {8,0x1e,11},
   {8,0x1d,19},
   {8,0x1c,35},
   {8,0x1b,13},
   {8,0x1a,49},
   {8,0x19,21},
   {8,0x18,41},
   {8,0x17,14},
   {8,0x16,50},
   {8,0x15,22},
   {8,0x14,42},
   {8,0x13,15},
   {8,0x12,51},
   {8,0x11,23},
   {8,0x10,43},
   {8,0x0f,25},
   {8,0x0e,37},
   {8,0x0d,26},
   {8,0x0c,38},
   {8,0x0b,29},
   {8,0x0a,45},
   {8,0x09,53},
   {8,0x08,57},
   {8,0x07,30},
   {8,0x06,46},
   {8,0x05,54},
   {8,0x04,58},
   {9,0x07,31},
   {9,0x06,47},
   {9,0x05,55},
   {9,0x04,59},
   {9,0x03,27},
   {9,0x02,39},
   {9,0x01,0}};

static HuffmanTableEntry rawMotion[] = { 
   {11,0x19,-16},
   {11,0x1b,-15},
   {11,0x1d,-14},
   {11,0x1f,-13},
   {11,0x21,-12},
   {11,0x23,-11},
   {10,0x13,-10},
   {10,0x15,-9},
   {10,0x17,-8},
   {8,0x07,-7},
   {8,0x09,-6},
   {8,0x0b,-5},
   {7,0x07,-4},
   {5,0x03,-3},
   {4,0x03,-2},
   {3,0x03,-1},
   {1,0x01,0},
   {3,0x02,1},
   {4,0x02,2},
   {5,0x02,3},
   {7,0x06,4},
   {8,0x0a,5},
   {8,0x08,6},
   {8,0x06,7},  
   {10,0x16,8},
   {10,0x14,9},
   {10,0x12,10},
   {12,0x22,11},
   {12,0x20,12},
   {12,0x1e,13},
   {12,0x1c,14},
   {12,0x1a,15},
   {12,0x18,16}};

static HuffmanTableEntry rawDctDcSizeLum[] = { 
   {3,0x4,0},
   {2,0x0,1},
   {2,0x1,2},
   {3,0x5,3},
   {3,0x6,4},
   {4,0xe,5},
   {5,0x1e,6},
   {6,0x3e,7},
   {7,0x7e,8},
   {8,0xfe,9},
   {9,0x1fe,10},
   {9,0x1ff,11}};

static HuffmanTableEntry rawDctDcSizeChrom[] = { 
   {2,0x00,0},
   {2,0x01,1},
   {2,0x02,2},
   {3,0x06,3},
   {4,0x0e,4},
   {5,0x1e,5},
   {6,0x3e,6},
   {7,0x7e,7},
   {8,0xfe,8},
   {9,0x1fe,9},
   {10,0x3fe,10},
   {10,0x3ff,11}};

/* decode value is run*0x100 + level */
static HuffmanTableEntry rawDctCoefZero[] = { 
   { 2,0x002,END_OF_BLOCK},  
   /*{ 1,0x001,0x001}, */
   { 2,0x003,0x001}, 
   { 3,0x003,0x101}, 
   { 4,0x004,0x002}, 
   { 4,0x005,0x201}, 
   { 5,0x005,0x003}, 
   { 5,0x007,0x301}, 
   { 5,0x006,0x401}, 
   { 6,0x006,0x102}, 
   { 6,0x007,0x501}, 
   { 6,0x005,0x601}, 
   { 6,0x004,0x701}, 
   { 7,0x006,0x004}, 
   { 7,0x004,0x202}, 
   { 7,0x007,0x801}, 
   { 7,0x005,0x901}, 
   { 6,0x001,ESCAPE},  
   { 8,0x026,0x005}, 
   { 8,0x021,0x006}, 
   { 8,0x025,0x103}, 
   { 8,0x024,0x302}, 
   { 8,0x027,0xa01}, 
   { 8,0x023,0xb01}, 
   { 8,0x022,0xc01}, 
   { 8,0x020,0xd01}, 
   {10,0x00a,0x007}, 
   {10,0x00c,0x104}, 
   {10,0x00b,0x203}, 
   {10,0x00f,0x402}, 
   {10,0x009,0x502}, 
   {10,0x00e,0xe01}, 
   {10,0x00d,0xf01}, 
   {10,0x008,0x1001}, 
   {12,0x01d,0x008}, 
   {12,0x018,0x009}, 
   {12,0x013,0x00a}, 
   {12,0x010,0x00b}, 
   {12,0x01b,0x105}, 
   {12,0x014,0x204}, 
   {12,0x01c,0x303}, 
   {12,0x012,0x403}, 
   {12,0x01e,0x602}, 
   {12,0x015,0x702}, 
   {12,0x011,0x802}, 
   {12,0x01f,0x1101}, 
   {12,0x01a,0x1201}, 
   {12,0x019,0x1301}, 
   {12,0x017,0x1401}, 
   {12,0x016,0x1501}, 
   {13,0x01a,0x00c}, 
   {13,0x019,0x00d}, 
   {13,0x018,0x00e}, 
   {13,0x017,0x00f}, 
   {13,0x016,0x106}, 
   {13,0x015,0x107}, 
   {13,0x014,0x205}, 
   {13,0x013,0x304}, 
   {13,0x012,0x503}, 
   {13,0x011,0x902}, 
   {13,0x010,0xa02}, 
   {13,0x01f,0x1601}, 
   {13,0x01e,0x1701}, 
   {13,0x01d,0x1801}, 
   {13,0x01c,0x1901}, 
   {13,0x01b,0x1a01}, 
   {14,0x01f,0x010}, 
   {14,0x01e,0x011}, 
   {14,0x01d,0x012}, 
   {14,0x01c,0x013}, 
   {14,0x01b,0x014}, 
   {14,0x01a,0x015}, 
   {14,0x019,0x016}, 
   {14,0x018,0x017}, 
   {14,0x017,0x018}, 
   {14,0x016,0x019}, 
   {14,0x015,0x01a}, 
   {14,0x014,0x01b}, 
   {14,0x013,0x01c}, 
   {14,0x012,0x01d}, 
   {14,0x011,0x01e}, 
   {14,0x010,0x01f}, 
   {15,0x018,0x020}, 
   {15,0x017,0x021}, 
   {15,0x016,0x022}, 
   {15,0x015,0x023}, 
   {15,0x014,0x024}, 
   {15,0x013,0x025}, 
   {15,0x012,0x026}, 
   {15,0x011,0x027}, 
   {15,0x010,0x028}, 
   {15,0x01f,0x108}, 
   {15,0x01e,0x109}, 
   {15,0x01d,0x10a}, 
   {15,0x01c,0x10b}, 
   {15,0x01b,0x10c}, 
   {15,0x01a,0x10d}, 
   {15,0x019,0x10e}, 
   {16,0x013,0x10f}, 
   {16,0x012,0x110}, 
   {16,0x011,0x111}, 
   {16,0x010,0x112}, 
   {16,0x014,0x603}, 
   {16,0x01a,0xb02}, 
   {16,0x019,0xc02}, 
   {16,0x018,0xd02}, 
   {16,0x017,0xe02}, 
   {16,0x016,0xf02}, 
   {16,0x015,0x1002}, 
   {16,0x01f,0x1b01}, 
   {16,0x01e,0x1c01}, 
   {16,0x01d,0x1d01}, 
   {16,0x01c,0x1e01}, 
   {16,0x01b,0x1f01}};

/* decode value is run*0x100 + level */
static HuffmanTableEntry rawDctCoefOne[] = { 
   { 4,0x006,END_OF_BLOCK}, 
   { 2,0x002,0x001}, 
   { 3,0x002,0x101}, 
   { 3,0x006,0x002}, 
   { 5,0x005,0x201}, 
   { 4,0x007,0x003}, 
   { 5,0x007,0x301}, 
   { 6,0x006,0x401}, 
   { 5,0x006,0x102}, 
   { 6,0x007,0x501}, 
   { 7,0x006,0x601}, 
   { 7,0x004,0x701}, 
   { 5,0x01c,0x004}, 
   { 7,0x007,0x202}, 
   { 7,0x005,0x801}, 
   { 7,0x078,0x901}, 
   { 6,0x001,ESCAPE}, 
   { 5,0x01d,0x005}, 
   { 6,0x005,0x006}, 
   { 7,0x079,0x103}, 
   { 8,0x026,0x302}, 
   { 7,0x07a,0xa01}, 
   { 8,0x021,0xb01}, 
   { 8,0x025,0xc01}, 
   { 8,0x024,0xd01}, 
   { 6,0x004,0x007}, 
   { 8,0x027,0x104}, 
   { 8,0x0fc,0x203}, 
   { 8,0x0fd,0x402}, 
   { 9,0x004,0x502}, 
   { 9,0x005,0xe01}, 
   { 9,0x007,0xf01}, 
   {10,0x00d,0x1001}, 
   { 7,0x07b,0x008}, 
   { 7,0x07c,0x009}, 
   { 8,0x023,0x00a}, 
   { 8,0x022,0x00b}, 
   { 8,0x020,0x105}, 
   {10,0x00c,0x204}, 
   {12,0x01c,0x303}, 
   {12,0x012,0x403}, 
   {12,0x01e,0x602}, 
   {12,0x015,0x702}, 
   {12,0x011,0x802}, 
   {12,0x01f,0x1101}, 
   {12,0x01a,0x1201}, 
   {12,0x019,0x1301}, 
   {12,0x017,0x1401}, 
   {12,0x016,0x1501}, 
   { 8,0x0fa,0x00c}, 
   { 8,0x0fb,0x00d}, 
   { 8,0x0fe,0x00e}, 
   { 8,0x0ff,0x00f}, 
   {13,0x016,0x106}, 
   {13,0x015,0x107}, 
   {13,0x014,0x205}, 
   {13,0x013,0x304}, 
   {13,0x012,0x503}, 
   {13,0x011,0x902}, 
   {13,0x010,0xa02}, 
   {13,0x01f,0x1601}, 
   {13,0x01e,0x1701}, 
   {13,0x01d,0x1801}, 
   {13,0x01c,0x1901}, 
   {13,0x01b,0x1a01}, 
   {14,0x01f,0x010}, 
   {14,0x01e,0x011}, 
   {14,0x01d,0x012}, 
   {14,0x01c,0x013}, 
   {14,0x01b,0x014}, 
   {14,0x01a,0x015}, 
   {14,0x019,0x016}, 
   {14,0x018,0x017}, 
   {14,0x017,0x018}, 
   {14,0x016,0x019}, 
   {14,0x015,0x01a}, 
   {14,0x014,0x01b}, 
   {14,0x013,0x01c}, 
   {14,0x012,0x01d}, 
   {14,0x011,0x01e}, 
   {14,0x010,0x01f}, 
   {15,0x018,0x020}, 
   {15,0x017,0x021}, 
   {15,0x016,0x022}, 
   {15,0x015,0x023}, 
   {15,0x014,0x024}, 
   {15,0x013,0x025}, 
   {15,0x012,0x026}, 
   {15,0x011,0x027}, 
   {15,0x010,0x028}, 
   {15,0x01f,0x108}, 
   {15,0x01e,0x109}, 
   {15,0x01d,0x10a}, 
   {15,0x01c,0x10b}, 
   {15,0x01b,0x10c}, 
   {15,0x01a,0x10d}, 
   {15,0x019,0x10e}, 
   {16,0x013,0x10f}, 
   {16,0x012,0x110}, 
   {16,0x011,0x111}, 
   {16,0x010,0x112}, 
   {16,0x014,0x603}, 
   {16,0x01a,0xb02}, 
   {16,0x019,0xc02}, 
   {16,0x018,0xd02}, 
   {16,0x017,0xe02}, 
   {16,0x016,0xf02}, 
   {16,0x015,0x1002}, 
   {16,0x01f,0x1b01}, 
   {16,0x01e,0x1c01}, 
   {16,0x01d,0x1d01}, 
   {16,0x01c,0x1e01}, 
   {16,0x01b,0x1f01}};

HuffmanTable *huffmanMbAddressing;
HuffmanTable *huffmanMbTypeForI;
HuffmanTable *huffmanMbTypeForP;
HuffmanTable *huffmanMbTypeForB;
HuffmanTable *huffmanMbTypeForISpatial;
HuffmanTable *huffmanMbTypeForPSpatial;
HuffmanTable *huffmanMbTypeForBSpatial;
HuffmanTable *huffmanCodedBlockPattern;
HuffmanTable *huffmanMotion;
HuffmanTable *huffmanDctDcSizeLum;
HuffmanTable *huffmanDctDcSizeChrom;
HuffmanTable *huffmanDctCoefZero;
HuffmanTable *huffmanDctCoefOne;

void InitMpeg2Tables(void)
{
   huffmanMbAddressing = NewHuffmanTable(rawMbAddressing,sizeof(rawMbAddressing)/sizeof(HuffmanTableEntry));
   huffmanMbTypeForI = NewHuffmanTable(rawMbTypeForI,sizeof(rawMbTypeForI)/sizeof(HuffmanTableEntry));
   huffmanMbTypeForP = NewHuffmanTable(rawMbTypeForP,sizeof(rawMbTypeForP)/sizeof(HuffmanTableEntry));
   huffmanMbTypeForB = NewHuffmanTable(rawMbTypeForB,sizeof(rawMbTypeForB)/sizeof(HuffmanTableEntry));
   huffmanMbTypeForISpatial = NewHuffmanTable(rawMbTypeForISpatial,sizeof(rawMbTypeForISpatial)/sizeof(HuffmanTableEntry));
   huffmanMbTypeForPSpatial = NewHuffmanTable(rawMbTypeForPSpatial,sizeof(rawMbTypeForPSpatial)/sizeof(HuffmanTableEntry));
   huffmanMbTypeForBSpatial = NewHuffmanTable(rawMbTypeForBSpatial,sizeof(rawMbTypeForBSpatial)/sizeof(HuffmanTableEntry));
   huffmanCodedBlockPattern = NewHuffmanTable(rawCodedBlockPattern,sizeof(rawCodedBlockPattern)/sizeof(HuffmanTableEntry));
   huffmanMotion = NewHuffmanTable(rawMotion,sizeof(rawMotion)/sizeof(HuffmanTableEntry));
   huffmanDctDcSizeLum = NewHuffmanTable(rawDctDcSizeLum,sizeof(rawDctDcSizeLum)/sizeof(HuffmanTableEntry));
   huffmanDctDcSizeChrom = NewHuffmanTable(rawDctDcSizeChrom,sizeof(rawDctDcSizeChrom)/sizeof(HuffmanTableEntry));
   huffmanDctCoefZero = NewHuffmanTable(rawDctCoefZero,sizeof(rawDctCoefZero)/sizeof(HuffmanTableEntry));
   huffmanDctCoefOne = NewHuffmanTable(rawDctCoefOne,sizeof(rawDctCoefOne)/sizeof(HuffmanTableEntry));
}











