
/*  (C) Copyright 1999 Rick Dean. */
/*  <vobTools@fdd.com>  http://fdd.com/vobTools */
/*  Released under version 2 of the GNU Public License. */                                                                         

/***************** sample code ******************************
 *  
 *      BitFile *bitFilePtr; 
 *      unsigned int bits;
 *
 *      bitFilePtr = NewBitFile();
 *      OpenWriteBitFile(bitFilePtr,"rick.bits","rick.trace");
 *      BitFileWriteBits(bitFilePtr,20,32342,"big number");
 *      CloseBitFile(bitFilePtr);
 *      OpenReadBitFile(bitFilePtr,"rick.bits","rick2.trace");
 *      bits = BitFileReadBits(bitFilePtr,20,"big number");  
 *      CloseBitFile(bitFilePtr);
 *      FreeBitFile(&bitFilePtr);
 *
 *************************************************************/

/*  All bit patterns are right-justified. (i.e. storing a three bit number */
/*  in a 32 bit data type, would only use the right three bits.) */

#ifndef _BITFILE_H_
#define _BITFILE_H_

#include <setjmp.h>

/* The format of a bitFileStruct is hidden from other source files, so they must use the */
/* functions in bitFile.c  */
typedef struct bitFileStruct BitFile;

BitFile *NewBitFile(void);
void FreeBitFile(BitFile **bitFileHdl);
void OpenReadBitFile(BitFile *bitFilePtr,char *bitFilename,char *traceFilename);
void OpenWriteBitFile(BitFile *bitFilePtr,char *bitFilename,char *traceFilename);
void BitFileMoreComment(BitFile *bitFilePtr,char const *comment);
int BitFileWriteBits(BitFile *bitFilePtr,int bitCount,unsigned int bits,char const *comment);
void CloseBitFile(BitFile *bitFilePtr);
void CloseBitFileWithAppend(BitFile *closingBitFilePtr,BitFile *appendingBitFilePtr);
unsigned int BitFileReadBits(BitFile *bitFilePtr,int bitCount,char const *comment);
unsigned int BitFilePeekBits(BitFile *bitFilePtr,int bitCount,char const *comment);
unsigned int BitFileReadAlignBits(BitFile *bitFilePtr,int bitCount,char const *comment);
unsigned int BitFilePeekAlignBits(BitFile *bitFilePtr,int bitCount,char const *commentStr);
unsigned int BitFileReadTilByte(BitFile* bitFilePtr,char const *commentStr);
int BitFileFTell(BitFile *bitFilePtr);
void BitFileFSeek(BitFile* bitFilePtr,int bitsFromStart,char const *commentStr);
int BitFileIsTraceOpen(BitFile* bitFilePtr);
int BitFileEOF(BitFile* bitFilePtr);
void BitFileFFlush(BitFile* bitFilePtr);
void BitFileSetAlarm(BitFile *bitFilePtr,int alarmBit,jmp_buf *alarmJmpBufPtr);
void BitFileAlarmOff(BitFile *bitFilePtr);

#endif /* _BITFILE_H_ */



