
/*  (C) Copyright 1999 Rick Dean. */
/*  Released under version 2 of the GNU Public License. */                                                                         
/*  <vobTools@fdd.com>  http://fdd.com/vobTools */

/* We borrow the nomenclature from the MPEG2 video standard (a.k.a. 13818-2 or N????). */

/* This program has been tested on only one moved, (which was kind of old and boring) */
/* so there are plenty of bugs left. */

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <setjmp.h>
#include <assert.h>
#include "videobits.h"
#include "bitfile.h"
#include "table.h"

jmp_buf resyncJmpBuf;

char inputFilename[MAX_NAME_LENGTHS] = "vts_01_1.mp2"; 
char traceFilename[MAX_NAME_LENGTHS] = "videotrace";  
int traceFlag = 0;
/*int desiredStreamId = 0xbb;*/

int foundGarbageFlag;
#if 0
int numPesPacketsFound;
int numPacksFound;
#endif
int numIFrames,numPFrames,numBFrames;

int progressive_sequence;
#define CHROMA_FORMAT_420 (1)
#define CHROMA_FORMAT_422 (2)
#define CHROMA_FORMAT_444 (3)
int chroma_format;
int block_count;
int horizontal_size;
int vertical_size;
int bit_rate;
int vbv_buffer_size;
int low_delay;
int quantiser_scale_code;   

int picture_coding_type;
int forward_f_code,backward_f_code;
int fcode00,fcode01,fcode10,fcode11;
int intra_dc_precision;
#define TOP_FIELD (1)
#define BOTTOM_FIELD (2)
#define FRAME_PICTURE (3)
int picture_structure;
int frame_pred_frame_dct;
int concealment_motion_vectors;
HuffmanTable *intraDctHuffmanTablePtr;
int progressive_frame;

int scalabilityFlag;
int lower_layer_temporal_reference;
int lower_layer_horizontal_offset;
int lower_layer_vertical_offset;
int spatial_temporal_weight_code_table_index;
int lower_layer_progressive_frame;
int lower_layer_deinterlaced_field_select;
int scalable_mode;

static void ParseSequenceHeader(BitFile *bitFilePtr)
{
   int load_intra_quantiser_matrix,load_non_intra_quantiser_matrix,aspect_ratio_information,frame_rate_code;
   static char const *aspectRatioNames[] = {"forbidden","square","3 by 4","9 by 16","1 by 2.21","reserved"};
   static char const *frameRateNames[] = {"forbidden","24000/1001","24","25",
                           "30000/1001","30","50","60000/1001","60","reserved"};
   char sizeComment[50];

   BitFileReadBits(bitFilePtr,32,"sequence_header_code");
   horizontal_size = BitFileReadBits(bitFilePtr,12,"horizontal_size_value = ");
   sprintf(sizeComment,"%d",horizontal_size);
   BitFileMoreComment(bitFilePtr,sizeComment);
   vertical_size = BitFileReadBits(bitFilePtr,12,"vertical_size_value = ");
   sprintf(sizeComment,"%d",vertical_size);
   BitFileMoreComment(bitFilePtr,sizeComment);
   aspect_ratio_information = BitFileReadBits(bitFilePtr,4,"aspect_ratio_information = ");
   if(aspect_ratio_information > 5) 
      aspect_ratio_information = 5;
   BitFileMoreComment(bitFilePtr,aspectRatioNames[aspect_ratio_information]);
   frame_rate_code = BitFileReadBits(bitFilePtr,4,"frame_rate_code = ");
   if(frame_rate_code > 9)
      frame_rate_code = 9;
   BitFileMoreComment(bitFilePtr,frameRateNames[frame_rate_code]);
   bit_rate = BitFileReadBits(bitFilePtr,18,"bit_rate_value");
   if(BitFileReadBits(bitFilePtr,1,"marker_bit (must be 1)") == 0) {
      BitFileMoreComment(bitFilePtr,"\n*** bad marker bit");
      longjmp(resyncJmpBuf,5);  /* error */
   };
   vbv_buffer_size = BitFileReadBits(bitFilePtr,10,"vbv_buffer_size_value");
   BitFileReadBits(bitFilePtr,1,"constrained_parameters_flag");
   load_intra_quantiser_matrix = BitFileReadBits(bitFilePtr,1,"load_intra_quantiser_matrix");
   if(load_intra_quantiser_matrix) {
      int matrixIndex;
      for(matrixIndex=0;matrixIndex<64;matrixIndex++)
         BitFileReadBits(bitFilePtr,8,"intra_quantiser_matrix");
   };
   load_non_intra_quantiser_matrix = BitFileReadBits(bitFilePtr,1,"load_non_intra_quantiser_matrix");
   if(load_non_intra_quantiser_matrix) {
      int matrixIndex;
      for(matrixIndex=0;matrixIndex<64;matrixIndex++)
         BitFileReadBits(bitFilePtr,8,"non_intra_quantiser_matrix");
   };
}

static void ParseSequenceExtension(BitFile *bitFilePtr)
{
   int profileId,levelId;
   static char const *chromaFormatNames[] = {"reserved", "4:2:0", "4:2:2", "4:4:4"};
   static char const *profileIdNames[] = {"reserved", "high", "spatially scalable", "SNR scalable", "main",
                                          "simple", "reserved", "high"};
   static char const *levelIdNames[] = {"high", "reserved", "high 1440", "reserved", "main", "reserved", "low"};

   BitFileReadBits(bitFilePtr,4,"extension_start_code_identifier = sequence extension");
   BitFileReadBits(bitFilePtr,1,"profile_and_level_indication escape bit");
   profileId = BitFileReadBits(bitFilePtr,3,"profile id = ");
   if(profileId > 5)
      profileId = 0;
   BitFileMoreComment(bitFilePtr,profileIdNames[profileId]);
   levelId = BitFileReadBits(bitFilePtr,4,"level id = ");
   if(levelId < 4 || levelId > 10)
      levelId = 5;
   BitFileMoreComment(bitFilePtr,levelIdNames[levelId - 4]);
   progressive_sequence = BitFileReadBits(bitFilePtr,1,"progressive_sequence");
   chroma_format = BitFileReadBits(bitFilePtr,2,"chroma_format = ");
   if(chroma_format == CHROMA_FORMAT_420)
      block_count = 6;
   else if(chroma_format == CHROMA_FORMAT_422)
      block_count = 8;
   else /* if(chroma_format == CHROMA_FORMAT_444) */
      block_count = 12;
   BitFileMoreComment(bitFilePtr,chromaFormatNames[chroma_format]);
   horizontal_size = (horizontal_size&0xfff) | (BitFileReadBits(bitFilePtr,2,"horizontal_size_extension") << 12);
   vertical_size = (vertical_size&0xfff) | (BitFileReadBits(bitFilePtr,2,"vertical_size_extension") << 12);
   bit_rate = (bit_rate&0xfff) | (BitFileReadBits(bitFilePtr,12,"bit_rate_extension") << 12);
   if(BitFileReadBits(bitFilePtr,1,"marker_bit (must be 1)") == 0) {
      BitFileMoreComment(bitFilePtr,"\n*** bad marker bit");
      longjmp(resyncJmpBuf,6);  /* error */
   };
   vbv_buffer_size = (vbv_buffer_size&0x3ff) | (BitFileReadBits(bitFilePtr,8,"vbv_buffer_size_extension") << 10);
   low_delay = BitFileReadBits(bitFilePtr,1,"low_delay");
   BitFileReadBits(bitFilePtr,2,"frame_rate_extension_n");
   BitFileReadBits(bitFilePtr,5,"frame_rate_extension_d");
}

static void ParseSequenceDisplayExtension(BitFile *bitFilePtr)
{
   int colour_description,video_format;
   static char const *videoFormatNames[] = {"component","PAL","NTSC","SECAM","MAC","unspecified","reserved","reserved"};

   BitFileReadBits(bitFilePtr,4,"extension_start_code_identifier = sequence display");
   video_format = BitFileReadBits(bitFilePtr,3,"video_format = ");
   BitFileMoreComment(bitFilePtr,videoFormatNames[video_format]);
   colour_description = BitFileReadBits(bitFilePtr,1,"colour_description");
   if(colour_description) {
      BitFileReadBits(bitFilePtr,8,"colour_primaries");
      BitFileReadBits(bitFilePtr,8,"transfer_characteristics");
      BitFileReadBits(bitFilePtr,8,"matrix_coefficients");
   };
   BitFileReadBits(bitFilePtr,14,"display_horizontal_size");
   if(BitFileReadBits(bitFilePtr,1,"marker_bit (must be 1)") == 0) {
      BitFileMoreComment(bitFilePtr,"\n*** bad marker bit");
      longjmp(resyncJmpBuf,7);  /* error */
   };
   BitFileReadBits(bitFilePtr,14,"display_vertical_size");
}

static void ParseSequenceScalableExtension(BitFile *bitFilePtr)
{
   BitFileReadBits(bitFilePtr,4,"extension_start_code_identifier = sequence scalable");
   scalable_mode = BitFilePeekBits(bitFilePtr,2,NULL);
   if(scalable_mode == 1) { /* spatial scalability */
      BitFileReadBits(bitFilePtr,2,"scalable_mode = spatial scalability");
      BitFileReadBits(bitFilePtr,4,"layer_id");
      BitFileReadBits(bitFilePtr,14,"lower_layer_prediction_horizontal_size");
      if(BitFileReadBits(bitFilePtr,1,"marker_bit (must be 1)") == 0) {
         BitFileMoreComment(bitFilePtr,"\n*** bad marker bit");
         longjmp(resyncJmpBuf,8);  /* error */
      };
      BitFileReadBits(bitFilePtr,14,"lower_layer_prediction_vertical_size");
      BitFileReadBits(bitFilePtr,5,"horizontal_subsampling_factor_m");
      BitFileReadBits(bitFilePtr,5,"horizontal_subsampling_factor_n");
      BitFileReadBits(bitFilePtr,5,"vertical_subsampling_factor_m");
      BitFileReadBits(bitFilePtr,5,"vertical_subsampling_factor_n");
   } else if(scalable_mode == 3) { /* temporal scalability */
      int picture_mux_enable;
      BitFileReadBits(bitFilePtr,2,"scalable_mode = temporal scalability");
      BitFileReadBits(bitFilePtr,4,"layer_id");
      picture_mux_enable = BitFileReadBits(bitFilePtr,1,"picture_mux_enable");
      if(picture_mux_enable) 
         BitFileReadBits(bitFilePtr,1,"picture_mux_enable");
      BitFileReadBits(bitFilePtr,3,"picture_mux_order");
      BitFileReadBits(bitFilePtr,3,"picture_mux_factor");
   } else if(scalable_mode == 2) { /* SNR scalability */
      BitFileReadBits(bitFilePtr,2,"scalable_mode = SNR");
      BitFileReadBits(bitFilePtr,4,"layer_id");
   } else {
      BitFileReadBits(bitFilePtr,2,"scalable_mode = data partitioning");
      BitFileReadBits(bitFilePtr,4,"layer_id");
   };
}

static void ParseUserData(BitFile *bitFilePtr)
{
   BitFileReadBits(bitFilePtr,32,"user_data_start_code");   /* 0x000001b2 */
   while(BitFilePeekBits(bitFilePtr,24,NULL) != 0x000001)
      BitFileReadBits(bitFilePtr,8,"user_data");
}

static void ParseGroupOfPicturesHeader(BitFile *bitFilePtr)
{
   int time_code;
   char timeStr[200];

   BitFileReadBits(bitFilePtr,32,"group_start_code");   /* 0x000001?? */
   time_code = BitFileReadBits(bitFilePtr,25,"time_code");
   sprintf(timeStr," = %s%02d:%02d:%02d frame %02d",(time_code&0x1000)?"drop-frame ":"",
           (time_code >> 19)&0x1f, (time_code >> 13)&0x3f, (time_code >> 6)&0x3f, time_code&0x3f);
   BitFileMoreComment(bitFilePtr,timeStr);
   BitFileReadBits(bitFilePtr,1,"closed_gop");
   BitFileReadBits(bitFilePtr,1,"broken_link");
   BitFileReadBits(bitFilePtr,5,"padding (should be zero)");
}

static void AddFCodeComment(BitFile *bitFilePtr,int fCode)
{
   static char const *fCodeNames[] = {"forbidden", "[-8,7.5]","[-16,15.5]","[-32,31.5]","[-64,63.5]",
                "[-128,127.5]","[-256,255.5]","[-512,511.5]","[-1024,1023.5]","[-2048,2047.5]", 
                "reserved","reserved","reserved","reserved","reserved","not used"};

   BitFileMoreComment(bitFilePtr,fCodeNames[fCode]);
}

static void ParsePictureHeader(BitFile *bitFilePtr)
{
   int bitsToPad;
   static char *pictureCodingTypeNames[] = {"forbidden", "intra-coded (I)", "predictive-coded (P)",
      "bidirectionally-predictive-coded (B)", "dc intra-coded (D)", "reserved", "reserved", "reserved"};

   BitFileReadBits(bitFilePtr,32,"picture_start_code");
   BitFileReadBits(bitFilePtr,10,"temporal_reference");
   picture_coding_type = BitFileReadBits(bitFilePtr,3,"picture_coding_type = ");
   BitFileMoreComment(bitFilePtr,pictureCodingTypeNames[picture_coding_type]);
   if(picture_coding_type == 1)
      numIFrames++;
   else if(picture_coding_type == 2)
      numPFrames++;
   else if(picture_coding_type == 3)
      numBFrames++;
   BitFileReadBits(bitFilePtr,16,"vbv_delay");
   if(picture_coding_type == 2 || picture_coding_type == 3) {
      BitFileReadBits(bitFilePtr,1,"full_pel_forward_vector");
      forward_f_code = BitFileReadBits(bitFilePtr,3,"forward_f_code = ");
      AddFCodeComment(bitFilePtr,forward_f_code);
   };
   if(picture_coding_type == 3) {
      BitFileReadBits(bitFilePtr,1,"full_pel_backward_vector");
      backward_f_code = BitFileReadBits(bitFilePtr,3,"backward_f_code = ");
      AddFCodeComment(bitFilePtr,backward_f_code);
   };
   for(;;) {
      if(BitFileReadBits(bitFilePtr,1,"extra_bit_picture") == 0)
         break;
      BitFileReadBits(bitFilePtr,8,"extra_information_picture");
   };
   bitsToPad = 8-(BitFileFTell(bitFilePtr)&7);
   if(bitsToPad != 8)
      BitFileReadBits(bitFilePtr,bitsToPad,"padding (should be 0)");
}

static void ParseCodingExtension(BitFile *bitFilePtr)
{
   int composite_display_flag,intra_vlc_format;
   static char const *pictureStructureNames[] = {"reserved", "top field", "bottom field", "frame picture"};
   static char const *intraDcPrecisionNames[] = {"8 bits", "9 bits", "10 bits", "11 bits"};

   BitFileReadBits(bitFilePtr,4,"extension_start_code_identifier = picture coding");   
   fcode00 = BitFileReadBits(bitFilePtr,4,"fcode[0][0] = ");   
   AddFCodeComment(bitFilePtr,fcode00);
   fcode01 = BitFileReadBits(bitFilePtr,4,"fcode[0][1] = ");   
   AddFCodeComment(bitFilePtr,fcode01);
   fcode10 = BitFileReadBits(bitFilePtr,4,"fcode[1][0] = ");   
   AddFCodeComment(bitFilePtr,fcode10);
   fcode11 = BitFileReadBits(bitFilePtr,4,"fcode[1][1] = ");   
   AddFCodeComment(bitFilePtr,fcode11);
   intra_dc_precision = BitFileReadBits(bitFilePtr,2,"intra_dc_precision = ");   
   BitFileMoreComment(bitFilePtr,intraDcPrecisionNames[intra_dc_precision]);   
   picture_structure = BitFileReadBits(bitFilePtr,2,"picture_structure = ");   
   BitFileMoreComment(bitFilePtr,pictureStructureNames[picture_structure]);   
   BitFileReadBits(bitFilePtr,1,"top_field_first");   
   frame_pred_frame_dct = BitFileReadBits(bitFilePtr,1,"frame_pred_frame_dct");   
   concealment_motion_vectors = BitFileReadBits(bitFilePtr,1,"concealment_motion_vectors");   
   BitFileReadBits(bitFilePtr,1,"q_scale_type");   
   intra_vlc_format = BitFileReadBits(bitFilePtr,1,"intra_vlc_format");   
   if(intra_vlc_format)
      intraDctHuffmanTablePtr = huffmanDctCoefOne;
   else
      intraDctHuffmanTablePtr = huffmanDctCoefZero;
   BitFileReadBits(bitFilePtr,1,"alternate_scan");   
   BitFileReadBits(bitFilePtr,1,"repeat_first_field");   
   BitFileReadBits(bitFilePtr,1,"chroma_420_type");   
   progressive_frame = BitFileReadBits(bitFilePtr,1,"progressive_frame");   
   composite_display_flag = BitFileReadBits(bitFilePtr,1,"composite_display_flag");   
   if(composite_display_flag) {
      BitFileReadBits(bitFilePtr,1,"v_axis");   
      BitFileReadBits(bitFilePtr,3,"field_sequence");   
      BitFileReadBits(bitFilePtr,1,"sub_carrier");   
      BitFileReadBits(bitFilePtr,7,"burst_amplitude");   
      BitFileReadBits(bitFilePtr,8,"sub_carrier_phase");   
   };
}

static void ParseQuantMatrixExtension(BitFile *bitFilePtr)
{
   int load_intra_quantiser_matrix,load_non_intra_quantiser_matrix;
   int load_chroma_intra_quantiser_matrix,load_chroma_non_intra_quantiser_matrix;

   BitFileReadBits(bitFilePtr,4,"extension_start_code_identifier = quant matrix");   
   load_intra_quantiser_matrix = BitFileReadBits(bitFilePtr,4,"load_intra_quantiser_matrix");   
   if(load_intra_quantiser_matrix) {
      int matrixIndex;
      for(matrixIndex=0;matrixIndex<64;matrixIndex++)
         BitFileReadBits(bitFilePtr,8,"intra_quantiser_matrix");
   }
   load_non_intra_quantiser_matrix = BitFileReadBits(bitFilePtr,1,"load_non_intra_quantiser_matrix");
   if(load_non_intra_quantiser_matrix) {
      int matrixIndex;
      for(matrixIndex=0;matrixIndex<64;matrixIndex++)
         BitFileReadBits(bitFilePtr,8,"non_intra_quantiser_matrix");
   };
   load_chroma_intra_quantiser_matrix = BitFileReadBits(bitFilePtr,4,"load_chroma_intra_quantiser_matrix");   
   if(load_chroma_intra_quantiser_matrix) {
      int matrixIndex;
      for(matrixIndex=0;matrixIndex<64;matrixIndex++)
         BitFileReadBits(bitFilePtr,8,"chroma_intra_quantiser_matrix");
   }
   load_chroma_non_intra_quantiser_matrix = BitFileReadBits(bitFilePtr,1,"load_chroma_non_intra_quantiser_matrix");
   if(load_chroma_non_intra_quantiser_matrix) {
      int matrixIndex;
      for(matrixIndex=0;matrixIndex<64;matrixIndex++)
         BitFileReadBits(bitFilePtr,8,"chroma_non_intra_quantiser_matrix");
   };
}

static void ParsePictureDisplayExtension(BitFile *bitFilePtr)
{
#if 0
   int frameCenterOffsetIndex;
#endif

   BitFileReadBits(bitFilePtr,4,"extension_start_code_identifier = sequence display");   
#if 0
   for(frameCenterOffsetIndex=0;frameCenterOffsetIndex < ;frameCenterOffsetIndex) {
      BitFileReadBits(bitFilePtr,16,"frame_centre_horizontal_offset");   
      if(BitFileReadBits(bitFilePtr,1,"marker_bit (must be 1)") == 0) {
         BitFileMoreComment(bitFilePtr,"\n*** bad marker bit");
         longjmp(resyncJmpBuf,9);  /* error */
      };
      BitFileReadBits(bitFilePtr,16,"frame_centre_vertical_offset");   
      if(BitFileReadBits(bitFilePtr,1,"marker_bit (must be 1)") == 0) {    
         BitFileMoreComment(bitFilePtr,"\n*** bad marker bit");
         longjmp(resyncJmpBuf,10);  /* error */
      };
   };
#endif
}

static void ParsePictureTemporalScalableExtension(BitFile *bitFilePtr)
{
   BitFileReadBits(bitFilePtr,4,"extension_start_code_identifier = picture temporal scalable");   
   BitFileReadBits(bitFilePtr,2,"referece_select_code");   
   BitFileReadBits(bitFilePtr,10,"forward_temporal_reference");   
   if(BitFileReadBits(bitFilePtr,1,"marker_bit (must be 1)") == 0) {
      BitFileMoreComment(bitFilePtr,"\n*** bad marker bit");
      longjmp(resyncJmpBuf,11);  /* error */
   };
   BitFileReadBits(bitFilePtr,10,"backward_temporal_reference");   
}

static void ParsePictureSpatialScalableExtension(BitFile *bitFilePtr)
{
   BitFileReadBits(bitFilePtr,4,"extension_start_code_identifier = picture spatial scalable");   
   lower_layer_temporal_reference = BitFileReadBits(bitFilePtr,10,"lower_layer_temporal_reference");   
   if(BitFileReadBits(bitFilePtr,1,"marker_bit (must be 1)") == 0) {
      BitFileMoreComment(bitFilePtr,"\n*** bad marker bit");
      longjmp(resyncJmpBuf,12);  /* error */
   };
   lower_layer_horizontal_offset = BitFileReadBits(bitFilePtr,10,"lower_layer_horizontal_offset");   
   if(BitFileReadBits(bitFilePtr,1,"marker_bit (must be 1)") == 0) {
      BitFileMoreComment(bitFilePtr,"\n*** bad marker bit");
      longjmp(resyncJmpBuf,13);  /* error */
   };
   lower_layer_vertical_offset = BitFileReadBits(bitFilePtr,10,"lower_layer_vertical_offset");   
   spatial_temporal_weight_code_table_index = BitFileReadBits(bitFilePtr,2,"spatial_temporal_weight_code_table_index");   
   lower_layer_progressive_frame = BitFileReadBits(bitFilePtr,1,"lower_layer_progressive_frame");   
   lower_layer_deinterlaced_field_select = BitFileReadBits(bitFilePtr,1,"lower_layer_deinterlaced_field_select");   
}

static void ParseCopyrightExtension(BitFile *bitFilePtr)
{
   BitFileReadBits(bitFilePtr,4,"extension_start_code_identifier = copyright");   
   BitFileReadBits(bitFilePtr,1,"copyright_flag");   
   BitFileReadBits(bitFilePtr,8,"copyright_identifier");   
   BitFileReadBits(bitFilePtr,1,"original_or_copy");   
   BitFileReadBits(bitFilePtr,7,"reserved");   
   if(BitFileReadBits(bitFilePtr,1,"marker_bit (must be 1)") == 0) {
      BitFileMoreComment(bitFilePtr,"\n*** bad marker bit");
      longjmp(resyncJmpBuf,14);  /* error */
   };
   BitFileReadBits(bitFilePtr,20,"copyright_number_1");     /* should be 22? */
   if(BitFileReadBits(bitFilePtr,1,"marker_bit (must be 1)") == 0) {
      BitFileMoreComment(bitFilePtr,"\n*** bad marker bit");
      longjmp(resyncJmpBuf,15);  /* error */
   };
   BitFileReadBits(bitFilePtr,22,"copyright_number_2");   
   if(BitFileReadBits(bitFilePtr,1,"marker_bit (must be 1)") == 0) {
      BitFileMoreComment(bitFilePtr,"\n*** bad marker bit");
      longjmp(resyncJmpBuf,16);  /* error */
   };
   BitFileReadBits(bitFilePtr,22,"copyright_number_3");   
}

static void ParseExtension(BitFile *bitFilePtr)
{
   int extension_start_code_identifier,bitsToPad,notDoneFlag;

   scalabilityFlag = 0;
   BitFileReadBits(bitFilePtr,32,"extension_start_code");   
   /* actually these have an enforced order and are not always allowable, but this will always parse correctly. */
   for(notDoneFlag=1;notDoneFlag;) {
      extension_start_code_identifier = BitFilePeekBits(bitFilePtr,4,NULL);  
      switch(extension_start_code_identifier) {
      case 1:
         ParseSequenceExtension(bitFilePtr);
         break;
      case 2:
         ParseSequenceDisplayExtension(bitFilePtr);
         break;
      case 3:
         ParseQuantMatrixExtension(bitFilePtr);
         break;
      case 4:
         ParseCopyrightExtension(bitFilePtr);
         break;
      case 5:
         scalabilityFlag = 1;
         ParseSequenceScalableExtension(bitFilePtr);
         break;
      case 7:
         ParsePictureDisplayExtension(bitFilePtr);
         break;
      case 8:
         ParseCodingExtension(bitFilePtr);
         break;
      case 9:
         scalabilityFlag = 1;
         ParsePictureSpatialScalableExtension(bitFilePtr);
         break;
      case 10:
         scalabilityFlag = 1;
         ParsePictureTemporalScalableExtension(bitFilePtr);
         break;
      default:
         notDoneFlag = 0;
         /*BitFileReadBits(bitFilePtr,4,"extension_start_code_identifier = reserved");   */
         break;
      };
   };
   bitsToPad = 8-(BitFileFTell(bitFilePtr)&7);
   if(bitsToPad != 8)
      BitFileReadBits(bitFilePtr,bitsToPad,"padding (should be 0)");
}

static void ParseMotionVectors(BitFile *bitFilePtr,int motion_vector_count,int dmvPresentFlag)
{
   extern HuffmanTable *huffmanMotion;

   for(;motion_vector_count;motion_vector_count--) {
  
      huffmanMotion = NULL;
   };
}


static void ParseDctCoefficients(BitFile *bitFilePtr,int firstCoefIndex,HuffmanTable *huffmanTablePtr)
{
   short dctArr[64];
   int dctIndex,sign,runLevel,run,level;
   char commentStr[100];

   dctIndex = firstCoefIndex;
   if(firstCoefIndex == 0 && huffmanTablePtr == huffmanDctCoefZero) {
      if(BitFilePeekBits(bitFilePtr,1,NULL) == 1) {
         BitFilePeekBits(bitFilePtr,1,"  DC DCT coef NOTE3");
         if(BitFilePeekBits(bitFilePtr,1,"sign = ")) {
            BitFileMoreComment(bitFilePtr,"-");
            dctArr[0] = -1;
         } else {
            BitFileMoreComment(bitFilePtr,"+");
            dctArr[0] = 1;
         };
         dctIndex = 1;
      };
   };
   for(;;) {
      runLevel = ReadHuffmanCode(bitFilePtr,huffmanTablePtr,"  DCT Coef = ");
      if(runLevel == HUFFMAN_ERROR) {
         BitFileMoreComment(bitFilePtr,"\n*** next bits not valid DCT variable length code");
         longjmp(resyncJmpBuf,17);  /* error */
      } else if(runLevel == END_OF_BLOCK) {
         BitFileMoreComment(bitFilePtr,"end of block");
         break;
      } else if(runLevel == ESCAPE) {
         BitFileMoreComment(bitFilePtr,"escape");
         run = BitFileReadBits(bitFilePtr,6,"  run");
         sign = BitFileReadBits(bitFilePtr,1,"  sign");
         level = BitFileReadBits(bitFilePtr,11,"  level");
         if(level == 0) {
            BitFileMoreComment(bitFilePtr,"\n*** level code of 0 was not legal");
            longjmp(resyncJmpBuf,2);  /* error */
         };
         if(sign)
            dctArr[dctIndex] = -2048 + level;
         else 
            dctArr[dctIndex] = level;
      } else {  /* else not an escape or end-of-block */
         level = runLevel & 0xff;
         run = runLevel >> 8;
         sprintf(commentStr," run=%d level=%d",run,level);
         BitFileMoreComment(bitFilePtr,commentStr);
         if(BitFileReadBits(bitFilePtr,1,"  sign = ")) {
            BitFileMoreComment(bitFilePtr,"-");
            dctArr[dctIndex] = -level;
         } else {
            BitFileMoreComment(bitFilePtr,"+");
            dctArr[dctIndex] = level;
         };
      };
      assert(run >= 0 && run < 64);
      dctIndex += 1 + run;
      if(dctIndex >= 64) {
         BitFileMoreComment(bitFilePtr,"\n*** run took us past 64 coefficients");
         longjmp(resyncJmpBuf,3);  /* error */
      };
   };
}

int useIntraDcPredictor;

static void ParseMacroblock(BitFile *bitFilePtr)
{
   int macroblock_address_increment,macroblock_type,dct_type,spatial_temporal_weight_code;
   int motion_type,coded_block_pattern,i,motion_vector_count;
   static const char *frameMotionNames[] = {"reserved","field-based","frame-based","dual-prime"};
   static const char *fieldMotionNames[] = {"reserved","field-based","16x8 MC","dual-prime"};
   static const int spatialTemporalClasses[] = { 1,1,1,1,3,1,3,1,2,1,2,1,2,2,3,1 };
   char commentStr[100];

   macroblock_address_increment = ReadHuffmanCode(bitFilePtr,huffmanMbAddressing," macroblock_address_increment = ");
   if(macroblock_address_increment == HUFFMAN_ERROR)
      longjmp(resyncJmpBuf,18);  /* go resync to a start code */ 
   sprintf(commentStr,"%d",macroblock_address_increment);
   BitFileMoreComment(bitFilePtr,commentStr);
   if(macroblock_address_increment)
      useIntraDcPredictor = 0;
   if(picture_coding_type == 1) {  /* if I picture */
      if(scalabilityFlag && scalable_mode == 1) /* spatial scalability */
         macroblock_type = ReadHuffmanCode(bitFilePtr,huffmanMbTypeForISpatial,"  macroblock_type");
      else
         macroblock_type = ReadHuffmanCode(bitFilePtr,huffmanMbTypeForI,"  macroblock_type");
   } else if(picture_coding_type == 2) {  /* if P picture */
      if(scalabilityFlag && scalable_mode == 1) /* spatial scalability */
         macroblock_type = ReadHuffmanCode(bitFilePtr,huffmanMbTypeForPSpatial,"  macroblock_type");
      else
         macroblock_type = ReadHuffmanCode(bitFilePtr,huffmanMbTypeForP,"  macroblock_type");
   } else if(picture_coding_type == 3) {  /* if B picture */
      if(scalabilityFlag && scalable_mode == 1) /* spatial scalability */
         macroblock_type = ReadHuffmanCode(bitFilePtr,huffmanMbTypeForBSpatial,"  macroblock_type");
      else
         macroblock_type = ReadHuffmanCode(bitFilePtr,huffmanMbTypeForB,"  macroblock_type");
   };
   if(macroblock_type == HUFFMAN_ERROR)
      longjmp(resyncJmpBuf,19);  /* go resync to a start code */ 
   if((macroblock_type & MB_SPATIAL_TEMPORAL_WEIGHT_CODE_FLAG) && spatial_temporal_weight_code_table_index != 0) 
       spatial_temporal_weight_code = BitFileReadBits(bitFilePtr,2,"spatial_temporal_weight_code");   
   if((macroblock_type & (MB_MOTION_FORWARD | MB_MOTION_BACKWARD))) {
      if(picture_structure == FRAME_PICTURE) {
         if(frame_pred_frame_dct == 0) {
            motion_type = BitFileReadBits(bitFilePtr,2,"frame_motion_type = ");   
            BitFileMoreComment(bitFilePtr,frameMotionNames[motion_type]); 
         };
         if(motion_type == 1 && (spatialTemporalClasses[spatial_temporal_weight_code_table_index*4 + 
            spatial_temporal_weight_code] > 2))  /* spatial_temporal_weight_class */
            motion_vector_count = 2;
         else 
            motion_vector_count = 1;
      } else {
         motion_type = BitFileReadBits(bitFilePtr,2,"field_motion_type");   
         BitFileMoreComment(bitFilePtr,fieldMotionNames[motion_type]); 
         if(motion_type == 2)
            motion_vector_count = 2;
         else 
            motion_vector_count = 1;
      };
      if(motion_type == 0) {
         BitFileMoreComment(bitFilePtr,"\n*** reserved motion type not permitted");
         longjmp(resyncJmpBuf,1);  /* error */
      };
   };
   if(picture_structure == FRAME_PICTURE && frame_pred_frame_dct == 0 && (macroblock_type & (MB_INTRA | MB_PATTERN)))
      dct_type = BitFileReadBits(bitFilePtr,1,"dct_type");   
   if((macroblock_type & MB_QUANT))
      quantiser_scale_code = BitFileReadBits(bitFilePtr,1,"quantiser_scale_code");   
   if((macroblock_type & MB_MOTION_FORWARD) || ((macroblock_type & MB_INTRA) && concealment_motion_vectors))
      ParseMotionVectors(bitFilePtr,motion_vector_count,motion_type == 3);
   if((macroblock_type & MB_MOTION_BACKWARD))
      ParseMotionVectors(bitFilePtr,motion_vector_count,motion_type == 3);
   if((macroblock_type & MB_INTRA) && concealment_motion_vectors)
      if(BitFileReadBits(bitFilePtr,1,"marker_bit (must be 1)") == 0) {
         BitFileMoreComment(bitFilePtr,"\n*** bad marker bit");
         longjmp(resyncJmpBuf,4);  /* error */
      };
   if((macroblock_type & MB_PATTERN)) {  
      coded_block_pattern = ReadHuffmanCode(bitFilePtr,huffmanCodedBlockPattern,"  coded_block_pattern_420") << 6;
      if(coded_block_pattern == HUFFMAN_ERROR)
         longjmp(resyncJmpBuf,20);  /* go resync to a start code */ 
      if(chroma_format == CHROMA_FORMAT_422) 
         coded_block_pattern |= BitFileReadBits(bitFilePtr,2,"coded_block_pattern_1") << 4;   
      if(chroma_format == CHROMA_FORMAT_444)
         coded_block_pattern |= BitFileReadBits(bitFilePtr,6,"coded_block_pattern_2");   
      for(i = 0;i < block_count;i++) {
         if((coded_block_pattern & 0x800))
            ParseDctCoefficients(bitFilePtr,0,huffmanDctCoefZero);
         coded_block_pattern <<= 1;
      }
   } else if((macroblock_type & MB_INTRA)) { /* else no coded_block_pattern so if intra */
      int dct_dc_size_luminance,dct_dc_size_chrominance;
      for(i=0;i < 4;i++) {  /* for the luminance blocks */
         dct_dc_size_luminance = ReadHuffmanCode(bitFilePtr,huffmanDctDcSizeLum,"  dct_dc_size_luminance");
         if(dct_dc_size_luminance == HUFFMAN_ERROR)
            longjmp(resyncJmpBuf,21);  /* go resync to a start code */ 
         if(dct_dc_size_luminance)
            BitFileReadBits(bitFilePtr,dct_dc_size_luminance,"   dct_dc_differential");   
         ParseDctCoefficients(bitFilePtr,0,intraDctHuffmanTablePtr);
      };
      for(;i < block_count;i++) {  /* for the chrominance blocks */
         dct_dc_size_chrominance = ReadHuffmanCode(bitFilePtr,huffmanDctDcSizeChrom,"  dct_dc_size_chrominance");
         if(dct_dc_size_chrominance == HUFFMAN_ERROR)
            longjmp(resyncJmpBuf,22);  /* go resync to a start code */ 
         if(dct_dc_size_chrominance)
            BitFileReadBits(bitFilePtr,dct_dc_size_chrominance,"   dct_dc_differential");   
         ParseDctCoefficients(bitFilePtr,0,intraDctHuffmanTablePtr);
      };
      useIntraDcPredictor = 1;
   };
   if(!(macroblock_type & MB_INTRA))
      useIntraDcPredictor = 0;
}

static void ParsePictureData(BitFile *bitFilePtr)
{
   int extra_bit_slice;

   BitFileReadBits(bitFilePtr,32,"slice_start_code");   
   if(vertical_size > 2800)
      BitFileReadBits(bitFilePtr,3,"slice_vertical_position_extension");   
#if 0
   if(sequence_scalable_extension && scalable_mode == 0) {  /* if data_partitioning */
      BitFileReadBits(bitFilePtr,7,"priority_breakpoint");   
   };
#endif
   quantiser_scale_code = BitFileReadBits(bitFilePtr,5,"quantiser_scale_code");   
   extra_bit_slice  = BitFilePeekBits(bitFilePtr,1,NULL);
   if(extra_bit_slice) {  
      BitFileReadBits(bitFilePtr,1,"intra_slice_flag"); /* would be 1 */
      BitFileReadBits(bitFilePtr,1,"intra_slice");   
      BitFileReadBits(bitFilePtr,1,"slice_picture_id_enable");   
      BitFileReadBits(bitFilePtr,6,"slice_picture_id");   
      for(;;) {
         extra_bit_slice = BitFilePeekBits(bitFilePtr,1,NULL);
         if(extra_bit_slice == 0)    
            break;
         BitFileReadBits(bitFilePtr,1,"extra_bit_slice");  /* would be 1 */ 
         BitFileReadBits(bitFilePtr,8,"extra_infomation_slice");   
      };
   };
   BitFileReadBits(bitFilePtr,1,"extra_bit_slice");  /* would be 0 */
   useIntraDcPredictor = 0;
   while(BitFilePeekBits(bitFilePtr,23,NULL) != 0) {
      ParseMacroblock(bitFilePtr);
   };
}

static void ParseVideo(BitFile *bitFilePtr)
{
   int bitsToSkip,errorCode;

   if((errorCode = setjmp(resyncJmpBuf))) {
      fprintf(stderr,"error %d bitFileFTell=%d.%d\n",errorCode,BitFileFTell(bitFilePtr)/8,BitFileFTell(bitFilePtr)%8);
   };
   for(;;) {  /* for every byte until we find a start code. */
      if(BitFilePeekBits(bitFilePtr,24,NULL) == 0x000001) { /* if a start code */
         if(BitFilePeekBits(bitFilePtr,32,NULL) == 0x00000100) { /* if a picture_start_code */
            ParsePictureHeader(bitFilePtr);
         } else if(BitFilePeekBits(bitFilePtr,32,NULL) <= 0x000001af) { /* if a slice_start_code */
            ParsePictureData(bitFilePtr);
         } else if(BitFilePeekBits(bitFilePtr,32,NULL) <= 0x000001b1) { /* if reserved  */
            BitFileReadBits(bitFilePtr,32,"reserved start code");
         } else if(BitFilePeekBits(bitFilePtr,32,NULL) == 0x000001b2) { /* if a user_data_start_code */
            ParseUserData(bitFilePtr);
         } else if(BitFilePeekBits(bitFilePtr,32,NULL) == 0x000001b3) { /* if a sequence_header_code */
            ParseSequenceHeader(bitFilePtr);
         } else if(BitFilePeekBits(bitFilePtr,32,NULL) == 0x000001b4) { /* if a sequence_error_code */
            BitFileReadBits(bitFilePtr,32,"sequence_error_code");
         } else if(BitFilePeekBits(bitFilePtr,32,NULL) == 0x000001b5) { /* if a extension_start_code */
            ParseExtension(bitFilePtr);
         } else if(BitFilePeekBits(bitFilePtr,32,NULL) == 0x000001b7) { /* if a sequence_end_code */
            BitFileReadBits(bitFilePtr,32,"sequence_end_code");
         } else if(BitFilePeekBits(bitFilePtr,32,NULL) == 0x000001b8) { /* if a group_start_code */
            ParseGroupOfPicturesHeader(bitFilePtr);
         } else /* else a start code */
            BitFileReadBits(bitFilePtr,32,"system (multiplex) start code!!!");
      } else {
         bitsToSkip = 8 - (BitFileFTell(bitFilePtr)&0x7);  /* between 1 and 8 to get us to next byte start */
         BitFileReadBits(bitFilePtr,bitsToSkip,"resyncSkip");
         if(BitFileEOF(bitFilePtr))
            return;
      };
   };
}

static void PrintHelp(void)
{
   printf("usage: videobits [options ..]\n"); 
   printf("   --input=filename (default is vts_01_1.mp2)\n"); 
   printf("   --bittrace=filename (default is videotrace)\n"); 
   printf("\n"); 
   printf("  videobits version 1.2\n"); 
   printf("  Written by Rick Dean <vobTools@fdd.com>.\n");
   printf("  Copyright (c) 1999 Rick Dean."); 
   printf("  Released under version 2 of the GNU Public License.\n");
   exit(0);
}

static void ReadCommandLineParms(int argc,char *argv[])
{

   if(argc == 1)
      PrintHelp();
   argc--;  /* skip name of program */
   argv++;  /* skip name of program */
   for(;argc;argc--,argv++) {  /* for every arg */
      if(strncasecmp(*argv,"--bittrace",10) == 0 && ((*argv)[10] == '\0' || (*argv)[10] == '=')) {
          traceFlag = 1;
          if((*argv)[10] == '=') {
             strncpy(traceFilename,&(*argv)[11],sizeof(traceFilename));
             traceFilename[sizeof(traceFilename)-1] = '\0';
          };
      } else if(strncasecmp(*argv,"--input=",8) == 0) {
          strncpy(inputFilename,&(*argv)[8],sizeof(inputFilename));
          inputFilename[sizeof(inputFilename)-1] = '\0';
#if 0
      } else if(strncasecmp(*argv,"--stream_id=",12) == 0) {
          if(strncasecmp(*argv,"--stream_id=0x",14) == 0)   /* if hex number specified */
             sscanf(*argv+12,"%x",&desiredStreamId);
          else
             desiredStreamId = atoi(*argv+10);  
          if(desiredStreamId < 0xbc || desiredStreamId > 0xff) {
             fprintf(stderr,"bad stream_id in %s\n",*argv);
             exit(-11);
          }
#endif
      } else {
          printf("problem with command arg \"%s\"\n",*argv);
          PrintHelp();
      };
   };
}

int main(int argc,char *argv[])
{
   BitFile *bitFilePtr;
  
   ReadCommandLineParms(argc,argv);
   InitMpeg2Tables();
   intraDctHuffmanTablePtr = huffmanDctCoefZero;
   bitFilePtr = NewBitFile();
   OpenReadBitFile(bitFilePtr,inputFilename,traceFlag?traceFilename:NULL);   
   ParseVideo(bitFilePtr);
   CloseBitFile(bitFilePtr);
   FreeBitFile(&bitFilePtr);
   return 0;
}





/* end of file */

