#!/usr/bin/perl -w
use strict;
#use diagnostics;

# -*- Mode: perl; indent-tabs-mode: nil -*-
#

package cgi;

# Decode the escaping of a URL
sub urlUnquote {
   my ($tounquote) = (@_);
   # we only want to unmap the param part not the path and file, so we do it elsewhere
   #$tounquote =~ tr/+/ /;       # pluses become spaces
   $tounquote =~ s/%([0-9a-fA-F]{2})/pack("c",hex($1))/ge;
   return $tounquote;
}

# Quotify a string, suitable for putting into a URL.
sub urlQuote {
   my($toencode) = (@_);
   $toencode=~s/([^a-zA-Z0-9_\-.^'\$~*])/uc sprintf("%%%02x",ord($1))/eg;
   # RFC 2616    ( ) < > @ , ; : \ / [ ] ? = { } " SP HT
   return $toencode;
}

sub Fatal {
   my ($error) = (@_);

   common::content_type("text/html");
   print("  <br><font color=red size=+2>Fatal Error</font><br>\n".
         "<font color=red>" . htmlQuote($error) . "</font>\n" .
         "</td></tr></table>");
   exit(1);
}

our %form;  # This is the has of form data submitted
           # The keys are the "name=" of the HTML form
our %fileh;  # here we store anonymous file handles to attachments

# useful for debugging.  Prints %form 
sub PrintFormHash {
   print("<hr><font size=+1>Form hash</font>\n<table>\n");
   my $rownum = 0;
   for my $key (sort(keys(%form))) {
      (my $value = $form{$key}) =~ s/\n/<br>\n/m;
      my $color = ($rownum++ & 1) ? "ffffff" : "dddddd";
      print("<tr bgcolor=$color><td>$key</td><td><font color=blue>$value</font></td></tr>\n"); 
   }
   print("</table>\n");
}

# Here we parse the HTML-form data from apache into a global public hash $cgi::form{} 
sub MakeFormHash {
   my $queryString = "";
   if(defined $ENV{"CONTENT_TYPE"} && $ENV{"CONTENT_TYPE"} =~ /multipart\/form-data.*boundary=([^;]+)/) { # if multipart
     my $boundary = $1;
     my $bytesToGo = $ENV{"CONTENT_LENGTH"} || 10000000;
     my($paramname,$filename);
     while($bytesToGo > 0 && defined(my $line = <STDIN>)) {  # for each line of the head
        $bytesToGo -= length($line);
        $line =~ s/[\r\n]+$//;  # remove trailing CRLF
        if($line =~ /^content-disposition:[^;]+(.*)/i) {
           my $value = $1;
           while($value =~ s/^\s*;\s*([^\s=;]+)\s*=\s*"(.+?)"([^"])/$3/ || $value =~ s/^\s*;\s*([^\s=;]+)\s*=\s*"(.+?)"$//) {
              my($n,$v) = ($1,$2);
              $paramname = $v if $n =~ /^name$/i;
              $filename = $v if $n =~ /^filename$/i;
           }
        }
        next unless $line eq "" && $paramname;
        if($filename) {  # if it is a file
           require IO::File;
           my $fh = IO::File::new_tmpfile() or fatal("500 internal error","No upload because new_tmpfile() not supported");
           while($bytesToGo > 0 && defined($line = <STDIN>)) {  # for each line of the body
              $bytesToGo -= length($line);
              last if substr($line,0,2 + length $boundary) eq "--$boundary";
              print $fh $line;
           }
           $fileh{$paramname} = $fh;
           $form{$paramname} = $filename;
        } else {  # else it is a regular parameter
           $form{$paramname} = "";
           while($bytesToGo > 0 && defined($line = <STDIN>)) {  # for each line of the body
              $bytesToGo -= length($line);
              last if substr($line,0,2 + length $boundary) eq "--$boundary";
              $form{$paramname} .= $line;
           }
        }
        last if substr($line,0,4 + length $boundary) eq "--$boundary--";
        ($paramname,$filename) = (undef,undef);
     }
   } elsif(defined($ENV{"REQUEST_METHOD"}) and $ENV{"REQUEST_METHOD"} eq "POST") {
      read(STDIN,$queryString,$ENV{"CONTENT_LENGTH"});
   } elsif(defined($ENV{"QUERY_STRING"})) {
      $queryString = $ENV{"QUERY_STRING"};
   }
   # $queryString looks like pw=passwd&name=rick+dean
   $queryString =~ tr/+/ /;       # pluses become spaces
   my @pairs = split('&',$queryString);
   for my $pair (@pairs) {
      if($pair =~ /([^=]*)=(.*)/) {
         $form{$1} = urlUnquote($2);
      };
   }
}

our %cookie;
our $cookielessFlag = 0;

# useful for debugging.  Prints %form
sub PrintCookieHash {
   print("<hr><font size=+1>Cookies hash</font><br>\n<font color=blue>\n");
   for my $key (sort(keys(%cookie))) {
      print("$key => $cookie{$key}<br>\n");
   }
   print("</font>\n");
}

sub MakeCookieHash {
   if (defined $ENV{"HTTP_COOKIE"}) {
      foreach my $pair (split(/;/, $ENV{"HTTP_COOKIE"})) {
         if ($pair =~ /^\s*([^=]*)=(.*)\s*$/) {
             $cookie{$1} = $2;
         } else {
             $cookie{$pair} = "";
         }
      }
   }
}

# PATH_INFO doesn't get the root case always correct.
sub GetPathAfterCgi {
   my $path;
   if($ENV{'SCRIPT_NAME'} && $ENV{'REQUEST_URI'}) {
      (my $scriptname = $ENV{'SCRIPT_NAME'}) =~ s/\/$//;  # remove trailing slash if present
      $path = substr($ENV{'REQUEST_URI'},length $scriptname) || ""; # remove SCRIPT_NAME prefix from REQUEST_URI
      $path =~ s/\?.*//s;  # trim after question mark
   } elsif(defined $ENV{'PATH_INFO'}) {
      $path = $ENV{'PATH_INFO'};
   } else {
      $path = "";
   }
   $path = urlUnquote($path);
   return $path;
}

# useful for debugging
sub PrintEnv {
   print("<hr><font size=+1>Environment</font><br>\n");
   for my $key (sort(keys(%ENV))) {
      print("$key => $ENV{$key}<br>\n"); 
   }
}

# This makes a new link being smart about the state we want to keep.
# The args are a list of "param=value".  
# The value should not be URL encoded because this function will.
sub Uri
{
   my ($filename,$params,$keepers) = @_;

   my %answer;
   # get all the keeper from the current page
   if(defined $keepers) {
      for my $keeper (@$keepers) {  # for every keeper
         if(defined($form{$keeper}) && $form{$keeper} ne "") {
            $answer{$keeper} = $form{$keeper};
         };
      };
   };
   # incorporate all the new parameters
   if(defined $params) {
      for my $parampair (@$params) {   # for every new parameter
         next if(!defined($parampair));
         my($param,$value) = split("=",$parampair,2);
         $answer{$param} = $value if $value ne "";
      };
   };
   my $answer = "";
   for my $key (keys(%answer)) {  # for every answer param
      $answer .= "$key=" . urlQuote($answer{$key}) . '&'; # append
   }
   chop($answer); # kill trailing '&'
   $answer = "?$answer" if $answer ne "";
   $filename = GetPathAfterCgi() if $filename eq "";
   if($filename =~ /^\//) {  # if begins with slash
      return("$ENV{'SCRIPT_NAME'}$filename$answer");
   } else {
      return("$filename$answer");
   }
}
sub Link
{
   return("<a href=\"". &Uri ."\">");  # call Uri() with same parameters
}


# returns a string converted to html
# double spaces and newlines are not processed
sub htmlQuote {
   my ($html) = (@_);
   return "&nbsp;" if !defined($html) || $html eq "";
   $html =~ s/\&/\&amp;/g;
   $html =~ s/</\&lt;/g;
   $html =~ s/>/\&gt;/g;
   $html =~ s/\n/\n<br>/g;
   return $html;
}
sub htmlQuoteForPre {
   my ($html) = (@_);
   return "&nbsp;" if !defined($html) || $html eq "";
   $html =~ s/\&/\&amp;/g;
   $html =~ s/</\&lt;/g;
   $html =~ s/>/\&gt;/g;
   return $html;
}
# Create a new has of everythin html quoted
sub htmlQuoteHash {
   my ($orig) = (@_);

   my %quoted;
   for my $key (keys(%$orig)) {
      $quoted{$key} = htmlQuote($$orig{$key});
   };
   return \%quoted;
}

our %keyword;  # This is the hash which stores all the replacements for the templates
sub PrintKeywordHash
{
   print("<hr>\n<font size=+1>Keyword hash</font>\n<table>\n");
   for my $key (sort(keys(%keyword))) {
      print("<tr><td bgcolor=dddddd>$key</td><td>$keyword{$key}</td></tr>\n");
   }
   print("</table>\n");
}

sub expanded_keyword {
    my($keyword) = @_;
    my $answer = $keyword{$keyword};
    if(!defined($answer)) {
       if(-r "$INC[0]/template/$keyword-template.html") {
          $answer = return_expanded_template("template/$keyword-template.html"); 
       } else {
          $answer = "<font color=orange>{{$keyword}}</font>";
       };
    };
    return $answer;
}

# This function uses %keyword the hash above. 
sub return_expanded_template {
    my($templateFilename) = @_;
    local(*FILE);
    $templateFilename = "$INC[0]/$templateFilename" if $templateFilename !~ /^\//;  # if not begging with slash
    open(FILE, "<$templateFilename") or fatal("500 internal error","Couldn't open $templateFilename: $!\n");
    read(FILE,my $answer,100000);
    close FILE;
    #$answer =~ s/{{(.*?)}}/$keyword{$1}/g;
    $answer =~ s/{{(.*?)}}/expanded_keyword($1)/eg;
    return($answer);
}
sub print_expanded_template {
    my($templateFilename) = @_;
    content_type("text/html");
    local(*FILE);
    $templateFilename = "$INC[0]/$templateFilename" if $templateFilename !~ /^\//;  # if not begging with slash
    open(FILE, "<$templateFilename") or fatal("500 internal error","Couldn't open $templateFilename: $!\n");
    while(defined(my $line = <FILE>)) {
       $line =~ s/{{(.*?)}}/expanded_keyword($1)/eg;
       print $line;
    };
    close FILE;
}

my $head_done_flag = 0;

# Call this if you want to declare a content-type.
# It keeps track of whether the header has been sent,
# which can be very useful when expounding error messages.
sub content_type($)
{
   my($type) = (@_);

   return if $head_done_flag++;
   print("content-type: $type\n\n");
}

my $fatalities = 0; # prevent possible infinite recursive looping

sub fatal
{
   die $_[1] if $fatalities++ > 3;  # prevent possible infinite recursive looping
   print STDERR "wildcat fatal(\"" . join('","',@_) . "\")\n";
   my $status = shift;
   print("Status: $status\n") if $status && ! $head_done_flag;
   $cgi::keyword{'title'} = $status || "";  # ensure defined
   $cgi::keyword{'warning'} .= "";  # ensure defined
   push(@_,"Please check your unix file permissions.") if $_[0] =~ /open/i || $_[0] =~ /creat/i || $_[0] =~ /move/i || $_[0] =~ /delete/i;
   $cgi::keyword{'error'} .= join("<br>\n",@_);
   print_expanded_template("template/error-template.html");
   debug_prints();
   exit(0);
} 

sub debug_prints {
   fatal("500 internal error","no header yet at debug_prints()") if !$head_done_flag;
   if($config::debug) {
      print "<p>The following only appears because <font color=red><code>\$config::debug=1</code></font> in config.pm<br>\n";
      cgi::PrintFormHash();
      cgi::PrintEnv();
      cgi::PrintKeywordHash();
      cgi::PrintCookieHash();
      print("<hr><font size=+2>$0 done</font>\n");
   }
}

1;
