#!/usr/bin/perl -w -T
use strict;
#use diagnostics;

#(This license is from zlib of Jean-loup Gailly and Mark Adler)
#
# Copyright (C) 2002 Frederick Dean <software@fdd.com>
#
#  This software is provided 'as-is', without any express or implied
#  warranty.  In no event will the authors be held liable for any damages
#  arising from the use of this software.
#
#  Permission is granted to anyone to use this software for any purpose,
#  including commercial applications, and to alter it and redistribute it
#  freely, subject to the following restrictions:
#
#  1. The origin of this software must not be misrepresented; you must not
#     claim that you wrote the original software. If you use this software
#     in a product, an acknowledgment in the product documentation would be
#     appreciated but is not required.
#  2. Altered source versions must be plainly marked as such, and must not be
#     misrepresented as being the original software.
#  3. This notice may not be removed or altered from any source distribution.
#
# Contributor(s):    Frederick Dean <software@fdd.com>

package dynamic;

use Digest::MD5 qw(md5_hex);
use Cwd;

our $login;  # if true the author has been authenticated

# The following lists do not include the path
our @filenames;  
our %imagenames; 
our %hidden;
our %highlight;
our %titles; 
our %dirnames; 
our %derived;
# key is filename
our %sizes;  
our %mtimes; 
our @imageorder;  # list of images to show in specific order

# Here we check that our wildcat_inventory.txt file is up to date.
# This file is used to detect changes to the html space, such as renaming a file.
sub inventory {
   my($diskpath) = @_;
   #### Inventory file stuff
   my $inventoryTime = 0;  # default is very long ago
   my $inventoryFilename = "wildcat_inventory.txt";
   if(-e $inventoryFilename) {
      $inventoryTime = ::FileModTime($inventoryFilename);
   };
   #### process all the files in the directory
   local(*DH);
   opendir(DH,".") or cgi::fatal("500 internal error","could not opendir ". cgi::htmlQuote($diskpath));
   foreach my $fname (readdir(DH)) {
      next if $fname eq "." || $fname eq ".."; 
      next if $fname =~ /~$/ || $fname =~ /^\./;   # ends with tilde or begins with dot
      next if $fname =~ /^wildcat_.*\.txt$/;   # hide wildcat files
      if($fname !~ /^([\w\-+=:'`!\@^~\., ]*)$/) {  # if not all good characters
         print STDERR ("wildcat.cgi: Illegal filename character in $fname of $diskpath (skipped)\n");
         next; 
      }
      $fname = $1;
      if($fname =~ /(\.[A-Z0-9]+)$/) { # if upper case extension
         my $extension = $1;
         $extension =~ tr/[A-Z]/[a-z]/;
         my $oldname = $fname;
         $fname =~ s/\.\w+$/$extension/;  # replace extension
         if(!rename("$oldname","$fname")) {
            print STDERR ("wildcat.cgi: Could not rename $diskpath$oldname to $fname\n");
            next; 
         }
      }
      push @filenames, $fname;
      (undef,undef,undef,undef,undef,undef,undef,$sizes{$fname},undef,$mtimes{$fname}) = stat($fname);
      if(-d $fname) {
         $dirnames{$fname} = 1;
      } elsif($fname =~ /\.jpe?g$/i) {
         $imagenames{$fname} = 1;
      };
   };
   delete $dirnames{"derived_images"};
   delete $dirnames{"CVS"};
   closedir(DH);
   #### process all the derived_images 
   if(! -e "derived_images") {
      mkdir("derived_images") or cgi::fatal("500 internal error","could not create ". cgi::htmlQuote("${diskpath}derived_images/"));
   }
   opendir(DH,"derived_images") or cgi::fatal("500 internal error","_could not opendir ". cgi::htmlQuote("${diskpath}derived_images/"));
   foreach my $fname (readdir(DH)) {
      next if $fname eq "." || $fname eq ".."; 
      $derived{$fname} = 1;
   };
   closedir(DH);
   #### process desired imageorder  
   my $imageorderFilename = "wildcat_imageorder.txt";
   local(*FD);
   if(open(FD,$imageorderFilename)) {
      while(defined(my $fname = <FD>)) {
         next if $fname =~ /^\s*#/ || $fname =~ /^\s*$/;  # skip line if it is a comment or blank
         chomp($fname);
         if($fname !~ /^([\w\-+=:'`!\@^~\., \/]*)$/) {  # if not all good characters
            print STDERR ("wildcat.cgi: Illegal filename $fname in $imageorderFilename\n");
            next; 
         }
         push(@imageorder,$1) if($imagenames{$1});
         $imagenames{$1} = 2;
      };
      close(FD);
   }
   my @missing;
   while(my($key, $value) = each %imagenames) {
      push(@missing,$key) if $value == 1;
   }
   push(@imageorder,sort @missing);
   #### process hidden images
   my $hiddenFilename = "wildcat_hidden.txt";
   if(open(FD,$hiddenFilename)) {
      while(defined(my $fname = <FD>)) {
         next if $fname =~ /^\s*#/ || $fname =~ /^\s*$/;  # skip line if it is a comment or blank
         chomp($fname);
         if($fname !~ /^([\w\-+=:'`!\@^~\., \/]*)$/) {  # if not all good characters
            print STDERR ("wildcat.cgi: Illegal filename $fname in $hiddenFilename\n");
            next; 
         }
         $hidden{$1} = 1;
      };
      close(FD);
   }
   #### process highlight images
   my $highlightFilename = "wildcat_highlight.txt";
   if(open(FD,$highlightFilename)) {
      while(defined(my $fname = <FD>)) {
         next if $fname =~ /^\s*#/ || $fname =~ /^\s*$/;  # skip line if it is a comment or blank
         chomp($fname);
         if($fname !~ /^([\w\-+=:'`!\@^~\., \/]*)$/) {  # if not all good characters
            print STDERR ("wildcat.cgi: Illegal filename $fname in $highlightFilename\n");
            next; 
         }
         $highlight{$1} = 1;
      };
      close(FD);
   }
   #### process titles 
   my $titlesFilename = "wildcat_title.txt";
   if(open(FD,$titlesFilename)) {
      while(defined(my $line = <FD>)) {
         next if $line =~ /^\s*#/ || $line =~ /^\s*$/;  # skip line if it is a comment or blank
         chomp($line);
         my($imagename,$title) = split(/\t/,$line,2);
         next unless $imagenames{$imagename};
         $titles{$imagename} = $title;
      };
      close(FD);
   }

}

# returns true if we are newly logged in
sub check_login
{
   $cgi::keyword{'login_ad'} = "<a href=.?logout=1>[logout]</a>";
   my $cookiepath = $ENV{'SCRIPT_NAME'} || "/";
   if($cgi::form{'logout'}) {
      print "Set-Cookie: wildcat_login=0 ; path=$cookiepath; expires=Sun, 30-Jun-2000 00:00:00 GMT\n".
            "Status: 302\n".
            "Location: .\n\n";
      return 1;  # return "new login" (but it isn't)
   }
   my $newcert;
   cgi::MakeCookieHash();
   my $oldcert = $cgi::cookie{'wildcat_login'};
   if($cgi::form{'password'}) {
      if(! defined $config::passwd) {
         cgi::fatal("500 misconfigured","Some bozo has not yet set the pass phrase.\n".
                                        "He needs to edit the <tt>config.pm</tt>.<br>\n");  
      }
      if($cgi::form{'password'} ne $config::passwd) {
         cgi::fatal("403 forbidden","Wrong pass phrase.\n");
      }
      my $time = time();      
      $newcert = sprintf("%x_",$time) . Digest::MD5::md5_hex($time . $config::passwd);
      print "Set-Cookie: wildcat_login=$newcert ; path=$cookiepath; expires=Sun, 30-Jun-2029 00:00:00 GMT\n".
            "Status: 302\n".
            "Location: .\n\n";
print STDERR "______ redirecting\n" if $config::debug;
      return 1;  # return "new login"
   } elsif($oldcert) { # else the were not trying to login, so check the cert
      if($oldcert =~ /^([0-9a-fA-F]+)_([0-9a-fA-F]{32})/) {
         my($time,$digest) = ($1,$2);
         if(time() > hex($time) + $config::idleTimeout) { # if cert is too old
            $cgi::keyword{'warning'} = "Your login has expired.<br>\n";
         } elsif($digest ne Digest::MD5::md5_hex(hex($time) . $config::passwd)) {
            $cgi::keyword{'warning'} = "The pass phrase has changed.<br>\n";
         } else {
            $time = time();
            $newcert = sprintf("%x_",$time) . Digest::MD5::md5_hex($time . $config::passwd);
            $login++;
         }
      } else {
         cgi::fatal("500 internal error","Internal Error: bad cert syntax") 
      };
   } 
   if($newcert) {
      print "Set-Cookie: wildcat_login=$newcert ; path=$cookiepath; expires=Sun, 30-Jun-2029 00:00:00 GMT\n";
print STDERR "______ is logged in\n" if $config::debug;
   } else {
      $cgi::keyword{'login_ad'} = "<a href=wildcat_login.html>[login]</a>";
      if($oldcert) {
print STDERR "______ destroying cookie\n" if $config::debug;
         print "Set-Cookie: wildcat_login=0 ; path=$cookiepath; expires=Sun, 30-Jun-2000 00:00:00 GMT\n";
      }
   }
   return 0;  # return "not new login"
}

sub print_login_form
{
   my($warning) = @_;
   $cgi::keyword{'warning'} .= $warning if $warning;
   $cgi::keyword{'formurl'} = $ENV{'REQUEST_URI'};
   $cgi::keyword{'formurl'} =~ s/\?.*//s;  # trim question mark and everything after
   $cgi::keyword{'formurl'} =~ s/wildcat_login.html$//;  # trim login name
   cgi::print_expanded_template("template/login-template.html");
}

sub print_upload_form
{
   my($path) = @_;
   if($login) {
      print("Cache-control: no-cache\n") if $path !~ /wildcat_upload.html$/;
      $cgi::keyword{'formurl'} = cgi::Uri($path);  
      cgi::print_expanded_template("template/upload-template.html");
   } else {
      print_login_form("You need to login first to upload");
   }
}

sub non_existent_dir
{
print STDERR "____ non_existent_dir($_[0])\n" if $config::debug;
   my($path) = @_;
   if($login) {
      $cgi::keyword{'warning'} .= "That album does not exist.<br>\nWould you like to create it?<br>\n";
      print("Cache-control: no-cache\n");
      $cgi::keyword{'formurl'} = $ENV{'REQUEST_URI'};
      $cgi::keyword{'formurl'} =~ s/\?.*//s;  # trim question mark and everything after
      cgi::print_expanded_template("template/upload-template.html");
   } else {
      print_login_form("That album does not exist.<br>\n" .
                       "If you log in, you can create it.<br>\n".
                       "or would you like to ". cgi::Link("/") ."go home</a>?");
   }
}

sub linkedPwd
{
   my($path) = @_;

   my $growth = "";
   my $answer .= " ". cgi::Link("/") ."<i>root</i></a> / \n";
   foreach my $dir (split("/",$path)) {
      next if $dir eq "";
      $growth .= "/$dir";
      $answer .= " ". cgi::Link("$growth/") . cgi::htmlQuote($dir) . "</a> / \n";
   }
   return $answer;
}

#  $imagename is the name of the original non-derived image. It is without path.
sub image_ref
{
   my($path,$imagename,$size) = @_;

   my $src; 
   (my $derivedname = $imagename) =~ s/(\.\w+$)/.$size$1/;
   my $derivedpathname = "derived_images/$derivedname";
#print STDERR "  ref imagename=$imagename dpn=$derivedpathname\n" if $config::debug;
   if($derived{$derivedname}) {
      if(::fileModTime($derivedpathname) < $mtimes{$imagename}) {  # if the main image was modified
         unlink($derivedpathname); 
      }
   }
   require wwwis;
   my($width,$height) = wwwis::imagesize($imagename);
   my $origpixels = $width * $height;
   $size = $#$config::sizes if($size > $#$config::sizes);
   my $pixels = $$config::sizes[$size];
   if(-s "derived_images/$derivedname") {  # if the thumbnail exists in the cache
      $src = "derived_images/mtime$mtimes{$imagename}-/$derivedname";
      ($width,$height) = wwwis::imagesize("derived_images/$derivedname");  # use its true size
   } elsif($origpixels * 0.8  > $pixels) {  # if it is big enough to be resized
      $src = "derived_images/mtime$mtimes{$imagename}-/$derivedname";
      my $newheight = sqrt($pixels*$height/$width);
      my $newwidth = sqrt($pixels*$width/$height);
      ($width,$height) = ($newwidth,$newheight); 
   } else {   # else we don't show a thumbnail, but the actual image itself.
      $src = "mtime$mtimes{$imagename}-/$imagename";
      # we return now because there is no need to link to a larger image/page
      return('<img border=0 src="'. cgi::Uri("$path$src") .
             "\" width=$width height=$height alt=\"". cgi::htmlQuote($imagename) ."\">");
   }
   # Done with the thumnail, now for the target of the link
   (my $basename = $imagename) =~ s/\.(\w+)$//;  # remove suffix
   my $target = "derived_images/$basename.". ($size+2) .".$1";
   if($size+2 > $#$config::sizes || ($origpixels*0.8) < $config::sizes->[$size+2]) { # of if the original was too small
      $target = $imagename;  # use the original
   };
   my $sizeinfo = "";
   if(my $filesize = -s $target) {
      $sizeinfo = "(" . (($filesize + 900) >> 10)  ."K) ";  # round mostly up
   }
   my $bigger = "$basename.". (($size < $#$config::sizes) ? $size+2 : $size) .".html";
   return(cgi::Link($bigger) . '<img border=0 src="'. cgi::Uri("$path$src") .
          "\" width=$width height=$height alt=\"$sizeinfo". cgi::htmlQuote($imagename) ."\"></a>");
}


sub show_image_info($$$)
{
   my($path,$imagename,$size) = @_;

   $cgi::keyword{'linkedPwd'} = linkedPwd($path);
   $cgi::keyword{'imagename'} = cgi::htmlQuote($imagename);
   my $order = 0;
   my @imageorder2 = $login ? @imageorder : grep { ! exists $hidden{$_} } @imageorder;  # exclude hidden if not logged in
   while($order <= $#imageorder2) {
      last if($imageorder2[$order] eq $imagename);
      $order++;
   }
   my $next = $imageorder2[$order < $#imageorder2 ? $order+1 : 0];
   my $prev = $imageorder2[$order ? $order-1 : $#imageorder2];
   $cgi::keyword{'nextname'} = $titles{$next};
   $cgi::keyword{'prevname'} = $titles{$prev};
   $next =~ s/\.[^\.]+$//;  # strip suffix
   $prev =~ s/\.[^\.]+$//;  # strip suffix
   $cgi::keyword{'nextname'} = cgi::htmlQuote($cgi::keyword{'nextname'} || $next);
   $cgi::keyword{'prevname'} = cgi::htmlQuote($cgi::keyword{'prevname'} || $prev);
   $cgi::keyword{'nexturl'} = cgi::Uri("$next.$size.html");
   $cgi::keyword{'prevurl'} = cgi::Uri("$prev.$size.html");
   $imagename =~ /^(.*)(\.\w+)$/i;  # find name without extension
   $cgi::keyword{'theimage'} =  image_ref($path,$imagename,$size);
   if(exists $hidden{$imagename}) {
      cgi::fatal("403 forbidden","Sorry, that image has been hidden and you are not logged in.") if(!$login);
      $cgi::keyword{'theimage'} = "<table bgcolor=ff4444><tr><td bgcolor=ff4444 width=100% border=3>hidden</td></tr>\n".
                                  "<tr><td>$cgi::keyword{'theimage'}</td></tr></table>\n";
   };
   require wwwis;
   my($width,$height) = wwwis::imagesize("$imagename");
   $size = $#$config::sizenames if($width * $height * 0.8 < $config::sizes->[$size]);
   foreach my $s (0..$#$config::sizenames) {
      next if($s != $#$config::sizenames && $width * $height * 0.8 < $config::sizes->[$s]); # full-orig or would-be thumbnail
      if($s == $size) {
         $cgi::keyword{'sizenames'} .= "<b>$config::sizenames->[$s]</b> &nbsp;";
      } else {
         $cgi::keyword{'sizenames'} .= cgi::Link("$path/$1.$s.html") . "$config::sizenames->[$s]</a> &nbsp;";
      };
   }
   $cgi::keyword{'orig-dimentions'} = "$width x $height";
   $cgi::keyword{'orig-size'} = $sizes{$imagename} || "error";
   $cgi::keyword{'orig-size'} =~ s/(\d)(\d{3})(\d{3})$/$1,$2,$3/;  # insert millions comma
   require Date::Format;
   $cgi::keyword{'mtime'} = Date::Format::time2str($config::timeformat,$mtimes{$imagename},$config::timezone);
   $cgi::keyword{'title'} = $titles{$imagename} || "";
   $cgi::keyword{'details'} = "";
   if($login) {
      # Not for the editing stuff
      $cgi::keyword{'hiddeninput'} = "<input type=hidden name=imagename value=". cgi::htmlQuote($imagename) .">\n".
                                     "<input type=hidden name=size value=$size>\n";
      $cgi::keyword{'notes'} = "";
      $cgi::keyword{'highlight'} = exists $highlight{$imagename} ? "CHECKED" : "";
      $cgi::keyword{'hidden'} = exists $hidden{$imagename} ? "CHECKED" : "";
      $cgi::keyword{'delete'} = "";
      $cgi::keyword{'details'} = cgi::return_expanded_template("template/detail-commands-template.html");
   }
   cgi::print_expanded_template("template/detail-template.html");
}

sub show_thumbnails
{
   my($path) = @_;
   $cgi::keyword{'linkedPwd'} = linkedPwd($path);
   # albums
   $cgi::keyword{'albums'} = cgi::Link("../") ."<img border=0 src=/icons/back.gif> parent directory </a><br>";
   foreach my $dirname (sort keys %dirnames) {
      $cgi::keyword{'albums'} .= cgi::Link("$dirname/") ."<img border=0 src=/icons/folder.gif> ". cgi::htmlQuote($dirname) ."</a><br>";
   }
   # images
   my $size = 1;
   $size = $1 if defined $cgi::form{'size'} && $cgi::form{'size'} =~ /^\s*(\d)\s*$/;  # if size is single digit
   my @pics = grep { ! $hidden{$_} } @imageorder;
   $cgi::keyword{'images'} .= "<table>\n";
   my $row = 0;
   while($#pics >= 0) {
      $cgi::keyword{'images'} .= "<tr>\n";
      my $toGoThisRow = 3;
      while($toGoThisRow--) {
         my $color = (($row + $toGoThisRow) & 1) ? "bbbbbb" : "dddddd";
         $cgi::keyword{'images'} .= ("<td bgcolor=$color align=center width=33%> ");
         if($#pics >= 0) {
            my $im = shift @pics;
            $cgi::keyword{'images'} .=  image_ref($path,$im,$size) ."<br>\n";
            $im =~ tr/_/ /;
            $cgi::keyword{'images'} .=  cgi::htmlQuote($titles{$im} || $im);
         } else {
            $cgi::keyword{'images'} .=  "&nbsp;";
         }
         $cgi::keyword{'images'} .=  " </td>\n";
      }
      $cgi::keyword{'images'} .= ("<tr>\n");
      $row++;
   }
   $cgi::keyword{'images'} .= ("</table>\n");
   # imagesizes
   foreach my $s (0 .. $#$config::sizes) {
      if($s == $size) { 
         $cgi::keyword{'imagesizes'} .= "<b>". $config::sizenames->[$s] ."</b> ";
      } else {
         $cgi::keyword{'imagesizes'} .= cgi::Link("",["size=$s"]) . $config::sizenames->[$s] ."</a> ";
      };
   }
   cgi::print_expanded_template("template/album-template.html");
}

# $filename is the same as the stuff after the last slash of $diskpath.
# $diskpath is absolute (beginngn with slash) and of the unix filesystem. 
#
#  e.g. if  http://localhost/wildcat/foo/bam/bar.html
#            $filename = "bar.html"
#            $diskpath = "/home/wildcat/foo/bam/"
#            $path = "foo/bam/"
#
sub dynamic
{
   my($path,$diskpath,$filename) = @_;
   if($filename eq "" && $path =~ s,/derived_images/$,/,) { # if they are trying to autoindex an image cache
      print("Status: 302 moved\nLocation: $ENV{'SCRIPT_NAME'}/$path\n\n");  # redirect to the album directory
      exit(0);
   }
print STDERR "!!!!!! dynamic\n" if $config::debug;
   if(! -d $diskpath) {   # if the current directory does NOT exist
      if($filename eq "") {  # if they have no filename
         if(-e $diskpath) {   # if the current directory is actually a file (we plan to ignore the trailing slash)
            $path =~ s,/$,,;  # strip off last slash 
            print("Status: 302 moved\nLocation: $ENV{'SCRIPT_NAME'}/$path\n\n");  # redirect to the file
         } else {  # we can't find anything
            non_existent_dir($diskpath);
         };
      } elsif($filename =~ /\.html?/i) {  # else there is a filename and it ends with .html
         cgi::fatal("404 not found","The document you requested is not found.<br>");
      } else {  # else there is a filename, and it is suitable to become an album
print STDER "###### would redirect to add trailing slash\n";
         ::redirectWithTrailingSlash();  # so we can prompt for login or upload
      }
      exit(0);
   };
   chdir($diskpath) or cgi::fatal("500 internal error","Could not chdir to ". cgi::htmlQuote($diskpath));
   cgi::MakeFormHash();
   $cgi::keyword{'pwd'} = $diskpath;
   $cgi::keyword{'warning'} = "";
   $cgi::keyword{'copyright'} = $config::copyright;
   $cgi::keyword{'hiddeninput'} = "";
   $cgi::keyword{'path'} = cgi::htmlQuote($path);
   $cgi::keyword{'albumurl'} = cgi::Uri($path);
   return if check_login();  # quit if redirected on new login
   inventory($diskpath);  # check for thumbnails and such
   if($cgi::form{'subsame'} || $cgi::form{'subprev'} || $cgi::form{'subnext'}) {
      require manage;
      manage::check_detail_commands($diskpath) and return;
   };
   foreach my $num (1..4) {  # for each possible upload parameter
      if($cgi::form{"file$num"}) {
         require upload;  # so we don't have to compile if not needed
         upload::uploadFile("file$num",$diskpath);
      };
      if($cgi::form{"url$num"}) {
         require upload;  # so we don't have to compile if not needed
         upload::uploadUrl("url$num",$diskpath);
      };
   };
   if($cgi::form{'order'}) {
      require manage;
      manage::reorder($diskpath) and return;
   };
   if($filename =~ /^wildcat_(\w+).html$/) {   # if wildcat internal page
      if($1 eq "upload") {
         print_upload_form($path);
      } elsif($1 eq "order") {
         require iprop;
         iprop::print_order_form($path);
      } elsif($1 eq "login") {
         print_login_form("Yes, yes, but can you remember?");
      } elsif($1 eq "ls") {
         require manage;
         manage::printDirListing($path,$diskpath);
      } else {
         cgi::fatal("404 not found","The document you requested is not found.<br>");
      }
   } else {  
      if($filename =~ /\.html?$/i) {  # if it ends with ".html"
         if($filename =~ s/\.(\d)\.html/.jpg/) {  # replace .9.html suffix with .jpg
            show_image_info($path,$filename,$1);
         } elsif($filename =~ s/\.html/.jpg/) {  # replace .html suffix with .jpg
            show_image_info($path,$filename,2);
         } else {  # else it is a non-existent .html file in a real directory
            cgi::fatal("404 not found","The document you requested is not found.<br>");
         };
      } elsif($filename eq "") { # else it is not a html file
         show_thumbnails($path);
      } else { # else it is not a non-existent file in a read directory
         cgi::fatal("404 not found","The document you requested is not found.<br>");
      }
   }
   if($login) {
      require manage;
      cgi::print_expanded_template("template/commands-template.html");
   }
   cgi::debug_prints();
}

1;

