
use strict;

#(This license is from zlib of Jean-loup Gailly and Mark Adler)
#
# Copyright (C) 2002 Frederick Dean <software@fdd.com>
#
#  This software is provided 'as-is', without any express or implied
#  warranty.  In no event will the authors be held liable for any damages
#  arising from the use of this software.
#
#  Permission is granted to anyone to use this software for any purpose,
#  including commercial applications, and to alter it and redistribute it
#  freely, subject to the following restrictions:
#
#  1. The origin of this software must not be misrepresented; you must not
#     claim that you wrote the original software. If you use this software
#     in a product, an acknowledgment in the product documentation would be
#     appreciated but is not required.
#  2. Altered source versions must be plainly marked as such, and must not be
#     misrepresented as being the original software.
#  3. This notice may not be removed or altered from any source distribution.
#
# Contributor(s):    Frederick Dean <software@fdd.com>

package exif;

use Fcntl;

#  Return 0 if nothing done
#  Return 1 if data stripped
#  Return <0 if error
sub stripJpeg
{
   my($filename) = @_;
   local(*FD);
   sysopen(FD,"$filename",O_RDONLY) or return -1;
   read(FD,my $buf,2) or return -2;  # cannot read?
   $buf eq "\xff\xd8" or return -3;  # not jpeg?
   my $output = $buf;
   while(1) {  # for each marker to process
      read(FD,$buf,4) or return -4;  # end of file before image stream?
      my($marker,$length) = unpack("nn",$buf);
      last if $marker < 0xff00;
      return -4 if $length < 2;  # syntax error 
      if($marker >= 0xffe0 && $marker <= 0xffef) {  # if we can discard this marker
         read(FD,$buf,$length-2) or return -5;  # end of file before image stream?
      } else {  # else we cannot discard this marker
         $output .= $buf;  
         read(FD,$buf,$length-2) or return -6;  # end of file before image stream?
         $output .= $buf;
      };
   }
   tell(FD) - length $output == 4 and return 0; # nothing to strip
   unlink("$filename.new");
   sysopen(OUT,"$filename.new", O_WRONLY | O_TRUNC | O_CREAT) or return -7;
   if(!print(OUT $output . $buf)) {
      unlink("$filename.new"); 
      return;
   };
   while(read(FD,$buf,2048)) {
      if(!print(OUT $buf)) {
         unlink("$filename.new"); 
         return;
      };
   }
   close(OUT); 
   close(FD); 
   rename("$filename.new",$filename);
}

1;

