#!/usr/bin/perl -w -T
use strict;
#use diagnostics;

#(This license is from zlib of Jean-loup Gailly and Mark Adler)
#
# Copyright (C) 2002 Frederick Dean <software@fdd.com>
#
#  This software is provided 'as-is', without any express or implied
#  warranty.  In no event will the authors be held liable for any damages
#  arising from the use of this software.
#
#  Permission is granted to anyone to use this software for any purpose,
#  including commercial applications, and to alter it and redistribute it
#  freely, subject to the following restrictions:
#
#  1. The origin of this software must not be misrepresented; you must not
#     claim that you wrote the original software. If you use this software
#     in a product, an acknowledgment in the product documentation would be
#     appreciated but is not required.
#  2. Altered source versions must be plainly marked as such, and must not be
#     misrepresented as being the original software.
#  3. This notice may not be removed or altered from any source distribution.
#
# Contributor(s):    Frederick Dean <software@fdd.com>

package iprop;

sub print_iprop_form
{
   my($path,$param_form) = @_;
   if(!$dynamic::login) {
      dynamic::print_login_form("You need to login first to edit image properties");
      return;
   }
   $cgi::keyword{'linkedPwd'} = dynamic::linkedPwd($path);
   cgi::print_expanded_template("template/iprop-template.html");
   my $size = 1;  # default thumbnail size
   $size = $1 if $cgi::form{'size'} && $cgi::form{'size'} =~ /^\s*(\d)\s*$/;  # if size is just a single digit
   my $bigger = $size+2;
   $bigger = $#$confg::sizes if $bigger > $#$config::sizes;
   require wwwis;
#print STDERR "images " . join(" ",@dynamic::imagenames) ."\n";
   # first all the show images in order, then the other in alphabetical order
   my %done;  # if an image has been displayed
   my $numImages = 0;
   foreach my $imagename (@dynamic::imageorder) {
      next if $done{$imagename};  # only list each image once
      $done{$imagename} = 1;  
      $numImages++;
      $imagename =~ /^(.*)(\.\w+)$/i;  # find name without extension
      $cgi::keyword{'imagename'} = cgi::htmlQuote("$imagename");
      $cgi::keyword{'theimage'} = cgi::Link("$path/$1.$bigger.html") . dynamic::image_ref($path,$imagename,$size) ."</a>";
      my($width,$height) = wwwis::imagesize("$imagename");
      my $mysize = $size;
      $mysize = $#$config::sizenames if($width * $height * 0.8 < $config::sizes->[$size]);
      $cgi::keyword{'sizenames'} = "";
      foreach my $s (0..$#$config::sizenames) {
         next if($s != $#$config::sizenames && $width * $height * 0.8 < $config::sizes->[$s]); # full-orig or would-be thumbnail
         if($s == $mysize) {
            $cgi::keyword{'sizenames'} .= "<b>$config::sizenames->[$s]</b> &nbsp;";
         } else {
            $cgi::keyword{'sizenames'} .= cgi::Link("$path/$1.$s.html") . "$config::sizenames->[$s]</a> &nbsp;";
         };
      }
      $cgi::keyword{'orig-dimentions'} = "$width x $height";
      $cgi::keyword{'orig-size'} = $dynamic::sizes{$imagename} || "error";
      $cgi::keyword{'orig-size'} =~ s/(\d)(\d{3})(\d{3})$/$1,$2,$3/;  # insert millions comma
      require Date::Format;
      $cgi::keyword{'mtime'} = Date::Format::time2str($config::timeformat,$dynamic::mtimes{$imagename},$config::timezone);
      $cgi::keyword{'param_form'} = &$param_form($imagename);
      cgi::print_expanded_template("template/iprop2-template.html");
   }
   $cgi::keyword{'numImages'} = $numImages;
   cgi::print_expanded_template("template/iprop3-template.html");
}

my $orderCount;

sub order_param_form
{
   my($imagename) = @_;
   $orderCount += 10;
   print STDERR "<form type=input size=20 value=$orderCount name=\"" . cgi::htmlQuote($imagename) ."\">\n";
   return "<input size=20 value=$orderCount name=\"" . cgi::htmlQuote($imagename) ."\">";
}

sub print_order_form
{
   my($path) = @_;
   $cgi::keyword{'submitName'} = "order";
   $cgi::keyword{'param_name'} = "Order";
   $orderCount = 100;
   print_iprop_form($path,\&order_param_form);
}

1;

