#!/usr/bin/perl -w -T
use strict;
#use diagnostics;

#(This license is from zlib of Jean-loup Gailly and Mark Adler)
#
# Copyright (C) 2002 Frederick Dean <software@fdd.com>
#
#  This software is provided 'as-is', without any express or implied
#  warranty.  In no event will the authors be held liable for any damages
#  arising from the use of this software.
#
#  Permission is granted to anyone to use this software for any purpose,
#  including commercial applications, and to alter it and redistribute it
#  freely, subject to the following restrictions:
#
#  1. The origin of this software must not be misrepresented; you must not
#     claim that you wrote the original software. If you use this software
#     in a product, an acknowledgment in the product documentation would be
#     appreciated but is not required.
#  2. Altered source versions must be plainly marked as such, and must not be
#     misrepresented as being the original software.
#  3. This notice may not be removed or altered from any source distribution.
#
# Contributor(s):    Frederick Dean <software@fdd.com>

use Date::Format;

package manage;

my $fileIcon = "/icons/folder.gif";
my $blankIcon = "/icons/generic.gif";
my $imageIcon = "/icons/image2.gif";
my $htmlIcon = "/icons/layout.gif";

sub printDirListing 
{
   my($path,$diskpath) = @_;
   if(!$dynamic::login) {  #  if the are not logged in
      dynamic::print_login_form();
      return;
   }
   cgi::content_type("text/html");
   print("<p>\n<table>\n");
   print("<tr bgcolor=224477><td><font color=white>filename</font></td>".
                            "<td><font color=white>size</font></td>".
                            "<td><font color=white>last modified</font></td><tr>\n");
   print("<tr><td><a href=../wildcat_ls.html><img border=0 src=/icons/back.gif> Parent directory</font></font></td>".
                            "<td><font>&nbsp;</td>".
                            "<td><font>&nbsp;</td><tr>\n");
   foreach my $fname (@dynamic::filenames) {
      next if $fname eq "derived_images";
      print("<tr><td>");
      if($dynamic::dirnames{$fname}) {
         print(" <a href=\"". cgi::htmlQuote($fname) ."/wildcat_ls.html\"><img border=0 src=$fileIcon> ");
      } elsif($fname =~ /\.html?$/i) {  # else it is a HTML file
         print(cgi::Link($fname) ."<img border=0 src=$htmlIcon> ");
      } elsif($dynamic::imagenames{$fname}) {  # else it is an image
         (my $target = $fname) =~ s/\.\w+$/.2.html/;
         print(cgi::Link($target) ."<img border=0 src=$imageIcon> ");
         #print dynamic::image_ref($path,$fname,0) . "</td><td>";
      } else {  # else it is a non-image file
         print(cgi::Link($fname) ."<img border=0 src=$blankIcon> ");
      }
      print(cgi::htmlQuote($fname),"</a></td>" .
           "<td align=right> ". $dynamic::sizes{$fname} ." </td>".
           "<td align=right>". Date::Format::time2str("%C",$dynamic::mtimes{$fname}) ."</td></tr>\n");
   }
   print("</table>\n");
}

sub purge_derived_images
{
   my($diskpath,$imagename) = @_;

   $imagename =~ /(.*)\.(\w+)$/ or cgi::fatal("500 internal error","Bad image filename name: ". cgi::htmlQuote($imagename));
   my($basename,$extension) = ($1,$2);
   (my $pattern = $imagename) =~ s/(\W)/\\$1/g;  # escape for regex
   $pattern = "^$pattern\\.\\d\\.$extension\$";
   local(*DH);
   opendir(DH,"$diskpath/derived_images") or cgi::fatal("500 internal error","cannot open ". cgi::htmlQuote("$diskpath/derived_images"));
   foreach my $fname (readdir(DH)) {
      if($fname =~ $pattern) {
         unlink($fname);
      };
   };
   close(DH);
}

sub write_imageorder
{
   my($diskpath) = @_;
   local(*FD);
   open(FD,">${diskpath}wildcat_imageorder.txt") or cgi::fatal("500 internal error","Could not open ". 
                                                    cgi::htmlQuote("${diskpath}wildcat_imageorder.txt"));
   print(FD map { "$_\n" } @dynamic::imageorder);
   close(FD);
}

sub write_highlights
{
   my($diskpath) = @_;
   local(*FD);
   open(FD,">${diskpath}wildcat_highlight.txt") or cgi::fatal("500 internal error","Could not open ". 
                                               cgi::htmlQuote("${diskpath}wildcat_highlight.txt"));
   print(FD map { "$_\n" } keys %dynamic::highlight);
   close(FD);
}

sub write_titles
{
   my($diskpath) = @_;
   local(*FD);
   open(FD,">${diskpath}wildcat_title.txt") or cgi::fatal("500 internal error","Could not open ". 
                                               cgi::htmlQuote("${diskpath}wildcat_title.txt"));
   print(FD map { "$_\t$dynamic::titles{$_}\n" } keys %dynamic::titles);
   close(FD);
}

sub write_hidden
{
   my($diskpath) = @_;
   local(*FD);
   open(FD,">${diskpath}wildcat_hidden.txt") or cgi::fatal("500 internal error","Could not open ". 
                                               cgi::htmlQuote("${diskpath}wildcat_hidden.txt"));
   print(FD map { "$_\n" } keys %dynamic::hidden);
   close(FD);
}

sub check_detail_commands
{
   my($diskpath) = @_;
print(STDERR "################### check_detail_commands()\n") if $config::debug;
foreach my $key (keys %cgi::form) { print STDERR $key . " ->\t\t" . $cgi::form{$key} ."\n" if $config::debug;};
   return 0 unless $cgi::form{'subsame'} || $cgi::form{'subprev'} || $cgi::form{'subnext'};
   cgi::fatal("403 forbidden","You must be logged in to change image properties.") unless $dynamic::login;
   cgi::fatal("500 internal error","no imagename param?") if ! $cgi::form{'imagename'};
   if($cgi::form{'imagename'} !~ /^([\w\-+=:'`!\@^~\., ]*)$/ || ! -s "$diskpath/$1") {  # if not all good characters
      cgi::fatal("500 internal error","bad imagename param? ". cgi::htmlQuote($cgi::form{'imagename'}));
   }
   my $imagename = $1;
   require resize;
   if($cgi::form{'rotate'}) {
      resize::rotate("$diskpath$imagename",$cgi::form{'rotate'});
      purge_derived_images($diskpath,$imagename);
   }
   if($cgi::form{'flip'} && $cgi::form{'flip'} eq "vert") {
      resize::flip_vertical("$diskpath$imagename");
      purge_derived_images($diskpath,$imagename);
   }
   if($cgi::form{'flip'} && $cgi::form{'flip'} eq "horiz") {
      resize::flip_horizontal("$diskpath$imagename");
      purge_derived_images($diskpath,$imagename);
   }
   if(defined $cgi::form{'title'}) {
      if($cgi::form{'title'} eq "") {  # if title is empty (will default to image name)
         delete $dynamic::titles{$imagename};
      } else {  # else title is not empty
         $dynamic::titles{$imagename} = $cgi::form{'title'};
         $dynamic::titles{$imagename} =~ tr/\r\n/  /;  # remove newlines
      }
      write_titles($diskpath);
   }
   if(! $cgi::form{'hidden'} ne ! $dynamic::hidden{$imagename}) {  # if hidden status is incorrect
      delete $dynamic::hidden{$imagename}; 
      $dynamic::hidden{$imagename} = 1 if $cgi::form{'hidden'}; 
      write_hidden($diskpath);
   }
   if(! $cgi::form{'highlight'} ne ! $dynamic::highlight{$imagename}) {  # if highlight status is incorrect
      delete $dynamic::highlight{$imagename}; 
      $dynamic::highlight{$imagename} = 1 if $cgi::form{'highlight'}; 
      write_highlights($diskpath);
   }
   if($cgi::form{'delete'} && $cgi::form{'delete2'}) {
      purge_derived_images($diskpath,$imagename);
      unlink("$diskpath$imagename") or cgi::fatal("500 internal error","Could not delete ". cgi::htmlQuote("$diskpath$imagename"));
   }
   if($cgi::form{'filename'} && $cgi::form{'filename'} ne $imagename) {
      if($cgi::form{'filename'} !~ /^([\w\-+=:'`!\@^~\., ]*)$/) { # if not all good characters
         cgi::fatal("403 denied","bad imagename character in ". cgi::htmlQuote($cgi::form{'filename'}).
                    " only letters, numbers, spaces, and -+=:'`!\@^~., are allowed<br>\n");
      }
      my $newname = $1;
      $imagename =~ /(\.[^\.]+)$/ and  # match extension
      $newname .= $1 if substr($newname,- length $1,length $1) ne $1;  # if newname has different extension, applend the old
      rename("$diskpath$imagename","$diskpath$newname") or cgi::fatal("internal error","Could not rename ". 
                         cgi::htmlQuote($imagename) ." to ". cgi::htmlQuote($newname));
      purge_derived_images($diskpath,$imagename);
      @dynamic::imageorder = map { $_ eq $imagename ? $newname : $_ } @dynamic::imageorder;
      write_imageorder($diskpath);
      $dynamic::titles{$newname} = delete $dynamic::titles{$imagename} if exists $dynamic::titles{$imagename};
      write_titles($diskpath);
      $dynamic::highlight{$newname} = delete $dynamic::highlight{$imagename} if exists $dynamic::highlight{$imagename};
      write_highlights($diskpath);
      $dynamic::hidden{$newname} = delete $dynamic::hidden{$imagename} if exists $dynamic::hidden{$imagename};
      write_hidden($diskpath);
      #$dynamic::mtimes{$newname} = delete $dynamic::mtimes{$imagename};
   }
   # Redirect to the next picture.
   # We redirect so when the reload to see the changed picture, they don't submit again and mess things up.
   # Also is silences the re-post warning.
   if($cgi::form{'subsame'}) {
      print("Status: 302\n".  "Location: .\n\n");
   } else {  # else we need a different picture
      my $index;
      for($index=$#dynamic::imageorder;$index > 0;$index--) {  # for each image (don't do the last)
         last if($dynamic::imageorder[$index] eq $imagename);
      };
      if($cgi::form{'subnext'}) {
         $index++;
         $index = 0 if $index > $#dynamic::imageorder;
      } else {  # else subprev
         $index--;
      };
      my $size = defined $cgi::form{'size'} ? $cgi::form{'size'} : 3;
      (my $location = $dynamic::imageorder[$index] || "") =~ s/\.\w+$/.$size.html/;  # fix extension
      print("Status: 302\n".
            "Location: $location\n\n");
   }
   return 1;  # yes we redirected
}

sub reorder
{
   my($diskpath) = @_;
   cgi::fatal("403 forbidden","You must be logged in to reorder images.") unless $dynamic::login;
   my %weights;
   foreach my $imagename (@dynamic::imageorder) {
      if(defined $cgi::form{$imagename} && $cgi::form{$imagename} =~ /^[\d.\-]+$/) {  # if is numeric
         $weights{$imagename} = $cgi::form{$imagename};
      } else {
         $weights{$imagename} = 1000000;
      };
   }
   @dynamic::imageorder = sort { $weights{$a} <=> $weights{$b} } keys %weights;
   write_imageorder($diskpath);
   print("Status: 302\n".  "Location: .\n\n");
   return 1;  # yes we redirected
}

1;

