
use strict;

#(This license is from zlib of Jean-loup Gailly and Mark Adler)
#
# Copyright (C) 2002 Frederick Dean <software@fdd.com>
#
#  This software is provided 'as-is', without any express or implied
#  warranty.  In no event will the authors be held liable for any damages
#  arising from the use of this software.
#
#  Permission is granted to anyone to use this software for any purpose,
#  including commercial applications, and to alter it and redistribute it
#  freely, subject to the following restrictions:
#
#  1. The origin of this software must not be misrepresented; you must not
#     claim that you wrote the original software. If you use this software
#     in a product, an acknowledgment in the product documentation would be
#     appreciated but is not required.
#  2. Altered source versions must be plainly marked as such, and must not be
#     misrepresented as being the original software.
#  3. This notice may not be removed or altered from any source distribution.
#
# Contributor(s):    Frederick Dean <software@fdd.com>

package resize;

use wwwis;

use Fcntl;

sub safe_exec
{
   my $stdout = shift;

   my $pid = fork();
   defined $pid or cgi::fatal("500 internal error","cannot fork: $!");
   return wait if $pid;  # parent waits and returns
   sysopen(STDOUT,$stdout, O_WRONLY | O_TRUNC | O_CREAT) or cgi::fatal("500 internal error","cannot create ". cgi::htmlQuote($stdout) ." $!");
   exec(@_) or cgi::fatal("500 internal error","cannot exec: $!");
   exit(0);
}

my @searchdirs = qw( /bin /usr/bin /usr/local/bin /usr/X11R6/bin );
sub findProgram
{
   foreach my $dir (@searchdirs) {
      return "$dir/$_[0]" if -x "$dir/$_[0]";
   }
   return undef;
}

my $convert_exe = findProgram("convert");
my $cjpeg_exe = findProgram("cjpeg");
my $djpeg_exe = findProgram("djpeg");
my $pnmscale_exe = findProgram("pnmscale");
my $jpegtran_exe = findProgram("jpegtran");

sub resize
{
   my($orig,$new,$pixels,$quality) = @_;

   cgi::fatal("500 internal error","too few pixels ($pixels)") if $pixels < 100;
   my($width,$height) = wwwis::imagesize("$orig");
   if($width * $height * 0.8 < $pixels) {  # if original isn't much bigger
      return;
   }
   $quality = ($pixels<30000) ?65:75 if !defined $quality;
   if(0) {
=trash
   } elsif($orig =~ /.jpe?g$/i && $cjpeg_exe && $djpeg_exe && $pnmscale_exe) {
      system("$djpeg_exe $orig | $pnmscale_exe --pixels $pixels | $cjpeg_exe -quality $quality >$new");
      if(! -s $new) {  # if the new thumbnail is too small
          unlink $new;  # delete it
          cgi::fatal("500 internal error","Error trying to create thumbnail ". cgi::htmlQuote($new) ."<br>\n");
          return;
      };
=cut
   } elsif ($convert_exe) {
      my $newheight = sqrt($pixels*$height/$width);
      my $newwidth = sqrt($pixels*$width/$height);
      system($convert_exe,"-resize","${newwidth}x$newheight","-quality",$quality,$orig,$new);
      if($pixels < 250000) {
          require exif;
          exif::stripJpeg($new);
      };
   } else {
      cgi::fatal("500 internal error","No thumbnail program.  Do you have ImageMagick?  Update paths in resize.pm.");
   }
   if(! -s $new) {  # if the new thumbnail is too small
       unlink $new;  # delete it
       cgi::fatal("500 internal error","Error trying to create thumbnail ". cgi::htmlQuote($new) ."<br>\n");
       return;
   };
   #my $modTime = ::fileModTime($old);
   #utime($modTime,$modTime,$new);  # fix modification time of new file
}

my %angles = ( -90 => "270",
                90 => "90",
               180 => "180",
               270 => "270");

sub rotate
{
   my($orig,$angle) = @_;

   my $tmpname = "$orig.tmp";

   if(!$angle || !$angles{$angle}) {
      cgi::fatal("500 internal error","Bad rotate angle: " . cgi::htmlQuote($angle));
   }
   $angle = $angles{$angle};
   if($orig =~ /.jpe?g$/i && $jpegtran_exe) {
      safe_exec("$tmpname",$jpegtran_exe,"-rotate",$angle,"-trim","-copy","all",$orig);
   } elsif ($convert_exe) {
      system($convert_exe,"-rotate",$angle,$orig,$tmpname);
   } else {
      cgi::fatal("500 internal error","No rotate program.  Do you have ImageMagick?  Update paths in resize.pm.");
   }
   if(! -s $tmpname) {  # if the new thumbnail is too small
       unlink $tmpname;  # delete it
       cgi::fatal("500 internal error","Error creating rotated ". cgi::htmlQuote($orig) ."<br>\n");
       return;
   };
   rename($tmpname,$orig) or cgi::fatal("500 internal error","Error moving rotated ". cgi::htmlQuote($orig) ."<br>\n");
}

sub flip_vertical
{
   my($orig) = @_;

   my $tmpname = "$orig.tmp";

   if($orig =~ /.jpe?g$/i && $jpegtran_exe) {
      safe_exec($tmpname,$jpegtran_exe,"-flip","vertical","-trim","-copy","all",$orig);
   } elsif ($convert_exe) {
      system($convert_exe,"-flip",$orig,$tmpname);
   } else {
      cgi::fatal("500 internal error","No flip program.  Do you have ImageMagick?  Update paths in resize.pm.");
   }
   if(! -s $tmpname) {  # if the new thumbnail is too small
       unlink $tmpname;  # delete it
       cgi::fatal("500 internal error","Error creating flipped ". cgi::htmlQuote($orig) ."<br>\n");
       return;
   };
   rename($tmpname,$orig) or cgi::fatal("500 internal error","Error moving flipped ". cgi::htmlQuote($orig) ."<br>\n");
}

sub flip_horizontal
{
   my($orig) = @_;

   my $tmpname = "$orig.tmp";

   if($orig =~ /.jpe?g$/i && $jpegtran_exe) {
      safe_exec($tmpname,$jpegtran_exe,"-flip","horizontal","-trim","-copy","all",$orig);
   } elsif ($convert_exe) {
      system($convert_exe,"-flop",$orig,$tmpname);
   } else {
      cgi::fatal("500 internal error","No flip program.  Do you have ImageMagick?  Update paths in resize.pm.");
   }
   if(! -s $tmpname) {  # if the new thumbnail is too small
       unlink $tmpname;  # delete it
       cgi::fatal("500 internal error","Error creating flipped ". cgi::htmlQuote($orig) ."<br>\n");
       return;
   };
   rename($tmpname,$orig) or cgi::fatal("500 internal error","Error moving flipped ". cgi::htmlQuote($orig) ."<br>\n");
}

1;

