
use strict;
#use diagnostics;

#(This license is from zlib of Jean-loup Gailly and Mark Adler)
#
# Copyright (C) 2002 Frederick Dean <software@fdd.com>
#
#  This software is provided 'as-is', without any express or implied
#  warranty.  In no event will the authors be held liable for any damages
#  arising from the use of this software.
#
#  Permission is granted to anyone to use this software for any purpose,
#  including commercial applications, and to alter it and redistribute it
#  freely, subject to the following restrictions:
#
#  1. The origin of this software must not be misrepresented; you must not
#     claim that you wrote the original software. If you use this software
#     in a product, an acknowledgment in the product documentation would be
#     appreciated but is not required.
#  2. Altered source versions must be plainly marked as such, and must not be
#     misrepresented as being the original software.
#  3. This notice may not be removed or altered from any source distribution.
#
# Contributor(s):    Frederick Dean <software@fdd.com>

package upload;

use Digest::MD5 qw(md5_hex);
use Fcntl;
use IO::File;

#
#  This package contains some less frequently used routines for uploading
#  files.  Notably absent is display of the upload form itself.
#

sub recursiveMkdir
{
   my $diskdir = "";
   foreach my $dir (split("/",$_[0])) {
      $diskdir .= "$dir/";
      mkdir($diskdir) if ! -e $diskdir;
   }
}

sub uploadFile
{
   my($param,$diskdir) = @_;
print STDERR "_____ upload(param=$param,diskdir=$diskdir)\n" if $config::debug;
   cgi::content_type("text/html");
   my $fh = $cgi::fileh{$param};
   return if !defined $fh || ! $dynamic::login;
   my $filename = $cgi::form{$param};
   print("Processing ". cgi::htmlQuote($filename) ."<br>\n");
   $filename =~ tr,/,_,;  # map slashes to underscores (but there should be none)
   $filename =~ s/~$//;  # remove trailing tilde 
   $filename =~ s/^\.//;  # remove leading dot 
   seek($fh,0,0);  # rewind to beginning
   read($fh,my $buf,1024);
   if($buf =~ /^\xff\xd8/ || $buf =~ /^hsi1/) {
      $filename .= ".jpg" if $filename !~ s/\.jpe?g$/.jpg/i;  # lower case extension
   } else {
      print("<font color=red>unkown file type ". cgi::htmlQuote($filename) ."</font><br>\n");
      close $fh;
      return;
   };
print STDERR "...... sysopen(,filename=$diskdir$filename,)\n" if $config::debug;
   recursiveMkdir($diskdir);
   # we need to resave it from the temporary file to the new directory
   if(!sysopen(FH2,"$diskdir$filename",O_WRONLY | O_CREAT)) {
      print("<font color=red>cannot open ". cgi::htmlQuote($diskdir . $filename) ."</font><br>\n");
      close $fh;
      return;
   };
   print FH2 $buf;
   while(read($fh,my $buffer,10 * 1024)) {
      print FH2 $buffer;
   };
   close $fh;
   close FH2;
   # now we need to check the thumnail situation.
print STDERR "-.-.-.-.-.- diskdir=$diskdir where=<<$cgi::form{'where'}>>\n" if $config::debug;
   for(my $i=0;$i <= $#dynamic::imageorder;$i++) {  # for every existing image shown
      splice(@dynamic::imageorder,$i--,1,()) if $dynamic::imageorder[$i] eq $filename;  # delete it if name is same
   };
   if($cgi::form{'where'} =~ /^top/) {
      unshift(@dynamic::imageorder,$filename);
   } elsif($cgi::form{'where'} =~ /^end/) {
      push(@dynamic::imageorder,$filename);
   } elsif($cgi::form{'where'} =~ /^rand/) {
      splice(@dynamic::imageorder,int(rand($#dynamic::imageorder+1)),0,$filename);
   };
   local(*FD);
   if(open(FD,">${diskdir}wildcat_imageorder.txt")) {
      print FD "# This file defines the images which will show, and in what order.\n# There should be one filename per line, no spaces.\n#\n";
      print(FD join("\n",@dynamic::imageorder) . "\n");
      close(FD);
   };
   if($cgi::form{'when'} =~ /^now/) {
      require resize;
      foreach my $size (0 .. $#$config::sizes-1) {
         my $pixels = $$config::sizes[$size];
         (my $thumbname = $filename) =~ s/(\.\w+)$/.$size$1/;
         print("Generating thumbnail ". cgi::htmlQuote($thumbname) ." ($pixels pixels)<br>\n");
         resize::resize("$diskdir$filename","${diskdir}derived_images/$thumbname",$pixels);
      }
   };
}

use IO::Socket;

# headers must end with "\015\012"
# The return value is a list.  
# The first element is the response body.
# The second element is a hash ref to the headers.
sub webget
{
   my($url,$headers,$body) = @_;

   $url =~ /^http:\/\/(.*?)(\/.*)$/ or return("bad url $url");;
   my($host,$pathfile) = ($1,$2);
   my $port = 80;
   if($host =~ s/:(\d+?)$//) { # remove optional port
      $port = $1;
   }
   my $EOL = "\015\012";
   if(!defined($headers)) {
      $headers = "";
   }
   if($host =~ /[a-zA-Z]/ && $headers !~ /^host:/mi) {
      $headers .= "Host: $host$EOL";
   }
   my $remote = IO::Socket::INET->new( Proto     => "tcp",
                                       PeerAddr  => $host,
                                       PeerPort  => "$port");
   if (!defined($remote)) {
      return "cannot connect to port $port on $host";
   }
   $remote->autoflush(1);
   if(defined($body)) {
      $headers .= "Content-Length: " . length($body) . $EOL;
      if($headers !~ /^content-type:/mi) {
         $headers .= "Content-Type: application/x-www-form-urlencoded$EOL";
      }
   }
   my $method = "GET";
   $method = "POST" if defined($body);
   print $remote "$method $pathfile HTTP/1.0$EOL" . $headers . $EOL;
   print $remote $body if(defined($body));
   my $status = <$remote>;  # first line returned looks like "HTTP/1.1 200 OK"
   $status =~ s/^\S+\s+//; # remove first token
   chomp $status;
   my $bytesToGo = 10000000;  # allow up to 10MB for HTTP/0.9
   while(defined(my $line = <$remote>)) {  # for each line of the head
     $bytesToGo = $1 if $line =~ /^content-length:\s*(\d+)/i;
     last if $line =~ /^[\r\n]+$/;  # empty line marks end of head
   }
   my $fh = IO::File::new_tmpfile() or fatal("500 internal error","No fetch because new_tmpfile() not supported");
   while($bytesToGo > 0 && $remote->read(my $line,1024 * 10)) {  # for each line of the body
     $bytesToGo -= length $line;
     print $fh $line;
   }
   close $remote;
   return ($status,$fh);
}

sub uploadUrl
{
   my($param,$diskdir) = @_;
   my $url = $cgi::form{$param};
   return if ! defined $url;
   $url =~ s/[\s]+$//s;  # delete trailing CRLF and white space
   return if ! $url || ! $dynamic::login;
   print("Fetching ". cgi::htmlQuote($url) ."<br>\n");
   my($status,$fh) = webget($url,undef);
   if($status !~ /^200/) { # if success
      print("Got <font color=red>". cgi::htmlQuote($status) ."</font><br>\n");
      close($fh);
      return;
   };
   print("Got ". cgi::htmlQuote($status) ."<br>\n");
   $cgi::fileh{"fetchedfile"} = $fh;
   ($cgi::form{"fetchedfile"} = "$url") =~ s/.*\///s;  # delete everything up to last slash
   uploadFile("fetchedfile",$diskdir);
}


1;

