#!/usr/bin/perl -w -T
use strict;
#use diagnostics;

#(This license is from zlib of Jean-loup Gailly and Mark Adler)
#
# Copyright (C) 2002 Frederick Dean <software@fdd.com>
#
#  This software is provided 'as-is', without any express or implied
#  warranty.  In no event will the authors be held liable for any damages
#  arising from the use of this software.
#
#  Permission is granted to anyone to use this software for any purpose,
#  including commercial applications, and to alter it and redistribute it
#  freely, subject to the following restrictions:
#
#  1. The origin of this software must not be misrepresented; you must not
#     claim that you wrote the original software. If you use this software
#     in a product, an acknowledgment in the product documentation would be
#     appreciated but is not required.
#  2. Altered source versions must be plainly marked as such, and must not be
#     misrepresented as being the original software.
#  3. This notice may not be removed or altered from any source distribution.
#
# Contributor(s):    Frederick Dean <software@fdd.com>

use lib "/home/wildcat/src";

$ENV{'PATH'} = '/bin:/usr/bin';
delete @ENV{'IFS', 'CDPATH', 'ENV', 'BASH_ENV'};

require config;
print STDERR "\n" if $config::debug;  # useful for debugging see /var/log/http/error_log
require cgi;

#print("content-type: text/html\n\n"); 
my $pathfile = cgi::GetPathAfterCgi();
print STDERR "_ _ _ pathfile=$pathfile\n";
sub redirectWithTrailingSlash {
   $ENV{'REQUEST_URI'} =~ s/\?/\/?/ or $ENV{'REQUEST_URI'} .= "/";  # insert slash before question mark, or append slash
   print "Status: 302 moved\nLocation: $ENV{'REQUEST_URI'}\n\nIt moved to <a href=\"$ENV{'REQUEST_URI'}\">here</a>"; 
   exit; 
}
if($pathfile eq "") {  # if we need to redirect with a trailing slash
   redirectWithTrailingSlash();
}
sub cleanPath {
   my($path) = @_;
   $path =~ s|/+|/|g;  # eliminate repeated slashes
   while($path =~ s|/[^/]+/\.\./|/|g) {};  # eliminate parent dir references /../
   while($path =~ s|/\./|/|g) {};  # eliminate self dir references /./
   while($path =~ s|^\./||g) {};  # eliminate self dir references /./
   while($path =~ s|/\.$||g) {};  # eliminate self dir references /./
   #$path =~ s|./$||g;  # eliminate trailing slash
   return $path;
}
$pathfile = cleanPath($pathfile);
# if the path after simplification begins with a .. element, then it is illegal
if($pathfile =~ /^\/\.\.\// || $pathfile eq "/..") {
   cgi::fatal("400 illegal path","The path you request is illegal because it has too many parent references (..)"); 
}
if($pathfile =~ /\/CVS\//) {  # if has /CVS/ in name
   cgi::fatal("403 forbidden","403 forbidden because CVS."); 
}
if($pathfile !~ /^([\w\-+=:'`!\@^~\., \/]*)$/) {  # if not all allowable characters
   cgi::fatal("403 forbidden","Your path contains forbidden characters."); 
}
$pathfile = $1;  # untaint
$pathfile =~ /(.*\/)(.*)/s or cgi::fatal("500","internal error"); # separate with last slash
my($path,$filename) = ($1,$2);
$path =~ s,/mtime\d*-/$,/,;  # strip of mtime virtual directory for image cache control
if($filename =~ /~$/ ||                    # if filename ends with ~
   $filename =~ /^\./ ||               # or begins with a dot
   $filename =~ /^wildcat_\w+.txt$/) { # or special wildcat files
   cgi::fatal("403 forbidden","Access forbidden.  Bad filename."); 
}
my $diskpath = $config::rootdir . $path;

sub httpTime {
   my ($sec,$min,$hour,$mday,$mon,$year,$wday) = gmtime(shift);
   my @week = qw(Sun Mon Tue Wed Thu Fri Sat);
   my @month = qw(x Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec);
   # RFC 2616:  Sun, 06 Nov 1994 08:49:37 GMT  (RFC 822, updated by RFC 1123)
   return sprintf("$week[$wday], %02d $month[$mon] %d %02d:%02d:%02d GMT",$mday,$year+1900,$hour,$min,$sec);
}
sub fileModTime { return (stat $_[0])[9] };
sub sendFile
{
   my($diskname) = @_;
   my $filesize = -s "$diskname" or cgi::fatal("500 internal error","file disappeared? ". cgi::htmlQuote($diskname));
   if(! -r $diskname) {  # if the file is not readable
      cgi::fatal("403 not readable","The file you requestable is not readable (unix permissions)"); 
   };
   print("Content-Length: $filesize\n");
   print("Last-Modified: ". httpTime(fileModTime($diskname)) ."\n");
   ##$diskname =~ s/[\|\;\&\<\>\(\)]/\\$1/g;  # escape path
   ##open(FD,"<$diskname\0") or die;
   sysopen(FD,"$diskname",0) or die;
   read(FD,my $buf,2048);
   my $content_type = "application/unkown";
   if($buf =~ /^GIF8/) {
      $content_type = "image/gif";
   } elsif($buf =~ /^\xff\xd8/ || $buf =~ /^hsi1/) {
      $content_type = "image/jpeg";
   } elsif($buf =~ /^\x89PNG/ || substr($buf,0,3) eq "PNG") {
      $content_type = "image/png";
   } elsif($filename =~ /\.html?$/i) {  # if filename ends in .html .HTML .htm or .HTM
      $content_type = "text/html";
   } elsif($filename =~ /\.txt$/i) {  # if filename ends in .txt or .TXT
      $content_type = "text/plain";
   };
print STDERR "sendFile($diskname) length=$filesize type=$content_type \n" if $config::debug;
   cgi::content_type($content_type);
   print $buf;
   while(read(FD,my $buf,2048)) {
      print $buf;
   };
}

# Check if this derived image is older than its ancestor
if($diskpath =~ /\/derived_images\/$/ && (my $mtime = fileModTime("$diskpath$filename"))) {
   (my $basename = $filename) =~ s/\.(\d)(\.\w+)$/$2/ or cgi::fatal("404 not found","404 not found"); 
   my $baseMtime = fileModTime("${diskpath}../$basename") || 4000000000; 
   unlink("$diskpath$filename") if $mtime < $baseMtime;  # delete stale derived image
}

# We use "require" instead of "use" so we don't pay the compile costs when we don't need to
if(! -e "$diskpath$filename") {  # if the file does not exist
print STDERR "_______ NO exist \$diskpath\$filename=$diskpath$filename\n" if $config::debug;
    if($diskpath =~ s/\/derived_images\/$/\//) { # else it is from an image cache
       (my $basename = $filename) =~ s/\.(\d)(\.\w+)$/$2/ or cgi::fatal("404 not found","404 not found"); 
       my $size = $1;
       if($size > $#$config::sizes || ! -e "$diskpath$basename") {
          cgi::fatal("404 not found","404 not found");
       };
       require resize;
       resize::resize("$diskpath$basename","${diskpath}derived_images/$filename",$$config::sizes[$size]);
       if(-e "${diskpath}derived_images/$filename") {
          sendFile("${diskpath}derived_images/$filename");
       } else {
          sendFile("$diskpath$basename");
       };
    } else {
       require dynamic || die $!;
       dynamic::dynamic($path,$diskpath,$filename);
    };
} elsif(-d "$diskpath$filename") {  # if the file is a directory
  if($filename eq "") {  # if url ends with a slash
print STDERR "_______ YES exist diskpath=$diskpath\n" if $config::debug;
     require dynamic || die $!;
     dynamic::dynamic($path,$diskpath,$filename);
  } else {  # else directory does not end with slash
     redirectWithTrailingSlash();
  };
} else {
   sendFile("$diskpath$filename");
}

# Don't call this function
sub silence_warning_silliness {
   $config::rootdir = $config::debug = $config::sizes;
}

print STDERR "\n" if $config::debug;  # useful for debugging see /var/log/http/error_log
exit 0;
